/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.trigram;

import java.util.function.Supplier;
import org.apache.lucene.index.IndexWriterConfig;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.WritableDatabaseIndex;
import org.neo4j.kernel.api.impl.index.builder.AbstractLuceneIndexBuilder;
import org.neo4j.kernel.api.impl.index.partition.WritableIndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramIndex;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;

public class TrigramIndexBuilder
extends AbstractLuceneIndexBuilder<TrigramIndexBuilder> {
    private final IndexDescriptor descriptor;
    private final Config config;
    private IndexSamplingConfig samplingConfig;
    private Supplier<IndexWriterConfig> writerConfigFactory;

    private TrigramIndexBuilder(IndexDescriptor descriptor, DatabaseReadOnlyChecker readOnlyChecker, Config config) {
        super(readOnlyChecker);
        this.descriptor = descriptor;
        this.config = config;
        this.samplingConfig = new IndexSamplingConfig(config);
        this.writerConfigFactory = () -> IndexWriterConfigs.standard(config);
    }

    public static TrigramIndexBuilder create(IndexDescriptor descriptor, DatabaseReadOnlyChecker readOnlyChecker, Config config) {
        return new TrigramIndexBuilder(descriptor, readOnlyChecker, config);
    }

    TrigramIndexBuilder withSamplingConfig(IndexSamplingConfig samplingConfig) {
        this.samplingConfig = samplingConfig;
        return this;
    }

    TrigramIndexBuilder withWriterConfig(Supplier<IndexWriterConfig> writerConfigFactory) {
        this.writerConfigFactory = writerConfigFactory;
        return this;
    }

    public DatabaseIndex<ValueIndexReader> build() {
        PartitionedIndexStorage storage = this.storageBuilder.build();
        TrigramIndex index = new TrigramIndex(storage, this.descriptor, this.samplingConfig, new WritableIndexPartitionFactory(this.writerConfigFactory), this.config);
        return new WritableDatabaseIndex(index, this.readOnlyChecker, this.permanentlyReadOnly);
    }
}

