/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.reader;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TotalHitCountCollector;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.collector.DocValuesCollector;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.TaskCoordinator;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.api.impl.schema.sampler.NonUniqueLuceneIndexSampler;
import org.neo4j.kernel.api.impl.schema.sampler.UniqueLuceneIndexSampler;
import org.neo4j.kernel.api.index.AbstractValueIndexReader;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class SimpleValueIndexReader
extends AbstractValueIndexReader {
    private final SearcherReference searcherReference;
    private final IndexDescriptor descriptor;
    private final IndexSamplingConfig samplingConfig;
    private final TaskCoordinator taskCoordinator;

    public SimpleValueIndexReader(SearcherReference searcherReference, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TaskCoordinator taskCoordinator) {
        super(descriptor);
        this.searcherReference = searcherReference;
        this.descriptor = descriptor;
        this.samplingConfig = samplingConfig;
        this.taskCoordinator = taskCoordinator;
    }

    public IndexSampler createSampler() {
        if (this.descriptor.isUnique()) {
            return new UniqueLuceneIndexSampler(this.getIndexSearcher(), this.taskCoordinator);
        }
        return new NonUniqueLuceneIndexSampler(this.getIndexSearcher(), this.taskCoordinator, this.samplingConfig);
    }

    public void query(QueryContext context, IndexProgressor.EntityValueClient client, IndexQueryConstraints constraints, PropertyIndexQuery ... predicates) throws IndexNotApplicableKernelException {
        Query query = SimpleValueIndexReader.toLuceneQuery(predicates);
        client.initialize(this.descriptor, this.search(query).getIndexProgressor("id", client), predicates, constraints, false);
    }

    private DocValuesCollector search(Query query) {
        try {
            DocValuesCollector docValuesCollector = new DocValuesCollector();
            this.getIndexSearcher().search(query, (Collector)docValuesCollector);
            return docValuesCollector;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Query toLuceneQuery(PropertyIndexQuery ... predicates) throws IndexNotApplicableKernelException {
        PropertyIndexQuery predicate = predicates[0];
        switch (predicate.type()) {
            case exact: {
                Value[] values = new Value[predicates.length];
                for (int i = 0; i < predicates.length; ++i) {
                    assert (predicates[i].type() == PropertyIndexQuery.IndexQueryType.exact) : "Exact followed by another query predicate type is not supported at this moment.";
                    values[i] = ((PropertyIndexQuery.ExactPredicate)predicates[i]).value();
                }
                return LuceneDocumentStructure.newSeekQuery(values);
            }
            case exists: {
                for (PropertyIndexQuery p : predicates) {
                    if (p.type() == PropertyIndexQuery.IndexQueryType.exists) continue;
                    throw new IndexNotApplicableKernelException("Exists followed by another query predicate type is not supported.");
                }
                return LuceneDocumentStructure.newScanQuery();
            }
            case range: {
                SimpleValueIndexReader.assertNotComposite(predicates);
                if (predicate.valueGroup() == ValueGroup.TEXT) {
                    PropertyIndexQuery.TextRangePredicate sp = (PropertyIndexQuery.TextRangePredicate)predicate;
                    return LuceneDocumentStructure.newRangeSeekByStringQuery(sp.from(), sp.fromInclusive(), sp.to(), sp.toInclusive());
                }
                throw new UnsupportedOperationException(String.format("Range scans of value group %s are not supported", predicate.valueGroup()));
            }
            case stringPrefix: {
                SimpleValueIndexReader.assertNotComposite(predicates);
                PropertyIndexQuery.StringPrefixPredicate spp = (PropertyIndexQuery.StringPrefixPredicate)predicate;
                return LuceneDocumentStructure.newRangeSeekByPrefixQuery(spp.prefix().stringValue());
            }
            case stringContains: {
                SimpleValueIndexReader.assertNotComposite(predicates);
                PropertyIndexQuery.StringContainsPredicate scp = (PropertyIndexQuery.StringContainsPredicate)predicate;
                return LuceneDocumentStructure.newWildCardStringQuery(scp.contains().stringValue());
            }
            case stringSuffix: {
                SimpleValueIndexReader.assertNotComposite(predicates);
                PropertyIndexQuery.StringSuffixPredicate ssp = (PropertyIndexQuery.StringSuffixPredicate)predicate;
                return LuceneDocumentStructure.newSuffixStringQuery(ssp.suffix().stringValue());
            }
        }
        throw new RuntimeException("Index query not supported: " + Arrays.toString(predicates));
    }

    private static void assertNotComposite(PropertyIndexQuery[] predicates) {
        assert (predicates.length == 1) : "composite indexes not yet supported for this operation";
    }

    public long countIndexedEntities(long entityId, CursorContext cursorContext, int[] propertyKeyIds, Value ... propertyValues) {
        TermQuery entityIdQuery = new TermQuery(LuceneDocumentStructure.newTermForChangeOrRemove(entityId));
        Query valueQuery = LuceneDocumentStructure.newSeekQuery(propertyValues);
        BooleanQuery.Builder entityIdAndValueQuery = new BooleanQuery.Builder();
        entityIdAndValueQuery.add((Query)entityIdQuery, BooleanClause.Occur.MUST);
        entityIdAndValueQuery.add(valueQuery, BooleanClause.Occur.MUST);
        try {
            TotalHitCountCollector collector = new TotalHitCountCollector();
            this.getIndexSearcher().search((Query)entityIdAndValueQuery.build(), (Collector)collector);
            return collector.getTotalHits();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.searcherReference.close();
        }
        catch (IOException e) {
            throw new IndexReaderCloseException(e);
        }
    }

    private IndexSearcher getIndexSearcher() {
        return this.searcherReference.getIndexSearcher();
    }
}

