/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Objects;
import org.apache.lucene.document.Document;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;

public abstract class LuceneIndexPopulator<INDEX extends DatabaseIndex<?>>
implements IndexPopulator {
    protected INDEX luceneIndex;
    protected LuceneIndexWriter writer;

    protected LuceneIndexPopulator(INDEX luceneIndex) {
        this.luceneIndex = luceneIndex;
    }

    public void create() {
        try {
            this.luceneIndex.create();
            this.luceneIndex.open();
            this.writer = this.luceneIndex.getIndexWriter();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void drop() {
        this.luceneIndex.drop();
    }

    public void add(Collection<? extends IndexEntryUpdate<?>> updates, CursorContext cursorContext) {
        assert (this.updatesForCorrectIndex(updates));
        try {
            this.writer.addDocuments(updates.size(), () -> updates.stream().map(u -> (ValueIndexEntryUpdate)u).map(LuceneIndexPopulator::updateAsDocument).filter(Objects::nonNull).iterator());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void close(boolean populationCompletedSuccessfully, CursorContext cursorContext) {
        try {
            if (populationCompletedSuccessfully) {
                this.luceneIndex.markAsOnline();
            }
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeAllSilently((AutoCloseable[])new DatabaseIndex[]{this.luceneIndex});
                throw throwable;
            }
        }
        IOUtils.closeAllSilently((AutoCloseable[])new DatabaseIndex[]{this.luceneIndex});
    }

    public void markAsFailed(String failure) {
        try {
            this.luceneIndex.markAsFailed(failure);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean updatesForCorrectIndex(Collection<? extends IndexEntryUpdate<?>> updates) {
        for (IndexEntryUpdate<?> update : updates) {
            if (update.indexKey().schema().equals(this.luceneIndex.getDescriptor().schema())) continue;
            return false;
        }
        return true;
    }

    private static Document updateAsDocument(ValueIndexEntryUpdate<?> update) {
        return LuceneDocumentStructure.documentRepresentingProperties(update.getEntityId(), update.values());
    }
}

