/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.sampler;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.BytesRef;
import org.neo4j.internal.helpers.TaskControl;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.impl.schema.populator.DefaultNonUniqueIndexSampler;
import org.neo4j.kernel.api.impl.schema.sampler.LuceneIndexSampler;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;

public class NonUniqueLuceneIndexSampler
extends LuceneIndexSampler {
    private final IndexSearcher indexSearcher;
    private final IndexSamplingConfig indexSamplingConfig;

    public NonUniqueLuceneIndexSampler(IndexSearcher indexSearcher, TaskControl taskControl, IndexSamplingConfig indexSamplingConfig) {
        super(taskControl);
        this.indexSearcher = indexSearcher;
        this.indexSamplingConfig = indexSamplingConfig;
    }

    public IndexSample sampleIndex(PageCursorTracer cursorTracer) throws IndexNotFoundKernelException {
        DefaultNonUniqueIndexSampler sampler = new DefaultNonUniqueIndexSampler(this.indexSamplingConfig.sampleSizeLimit());
        IndexReader indexReader = this.indexSearcher.getIndexReader();
        for (LeafReaderContext readerContext : indexReader.leaves()) {
            try {
                Set<String> fieldNames = NonUniqueLuceneIndexSampler.getFieldNamesToSample(readerContext);
                for (String fieldName : fieldNames) {
                    BytesRef termsRef;
                    Terms terms = readerContext.reader().terms(fieldName);
                    if (terms == null) continue;
                    TermsEnum termsEnum = terms.iterator();
                    while ((termsRef = termsEnum.next()) != null) {
                        sampler.include(termsRef.utf8ToString(), termsEnum.docFreq());
                        this.checkCancellation();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return sampler.sample(indexReader.numDocs(), cursorTracer);
    }

    private static Set<String> getFieldNamesToSample(LeafReaderContext readerContext) {
        HashSet<String> fieldNames = new HashSet<String>();
        LeafReader reader = readerContext.reader();
        reader.getFieldInfos().forEach(info -> {
            String name = info.name;
            if (!"id".equals(name)) {
                fieldNames.add(name);
            }
        });
        return fieldNames;
    }
}

