/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.backup;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.IndexCommit;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;

class ReadOnlyIndexSnapshotFileIterator
extends PrefetchingIterator<File>
implements ResourceIterator<File> {
    private final File indexDirectory;
    private final Iterator<String> fileNames;
    private final IndexCommit indexCommit;

    ReadOnlyIndexSnapshotFileIterator(File indexDirectory, IndexCommit indexCommit) throws IOException {
        this.indexDirectory = indexDirectory;
        this.indexCommit = indexCommit;
        this.fileNames = this.indexCommit.getFileNames().iterator();
    }

    protected File fetchNextOrNull() {
        if (!this.fileNames.hasNext()) {
            return null;
        }
        return new File(this.indexDirectory, this.fileNames.next());
    }

    public void close() {
    }

    IndexCommit getIndexCommit() {
        return this.indexCommit;
    }

    File getIndexDirectory() {
        return this.indexDirectory;
    }
}

