/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.Bits;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.impl.index.LuceneDocumentRetrievalException;
import org.neo4j.kernel.api.impl.index.SearcherReference;

public class LucenePartitionAllDocumentsReader
implements BoundedIterable<Document> {
    private final SearcherReference searcherReference;
    private final IndexSearcher searcher;
    private final IndexReader reader;

    public LucenePartitionAllDocumentsReader(SearcherReference searcherReference) {
        this.searcherReference = searcherReference;
        this.searcher = searcherReference.getIndexSearcher();
        this.reader = this.searcher.getIndexReader();
    }

    public long maxCount() {
        return this.reader.maxDoc();
    }

    public Iterator<Document> iterator() {
        return new PrefetchingIterator<Document>(){
            DocIdSetIterator idIterator;
            {
                this.idIterator = LucenePartitionAllDocumentsReader.this.iterateAllDocs();
            }

            protected Document fetchNextOrNull() {
                try {
                    int doc = this.idIterator.nextDoc();
                    if (doc == Integer.MAX_VALUE) {
                        return null;
                    }
                    return LucenePartitionAllDocumentsReader.this.getDocument(doc);
                }
                catch (IOException e) {
                    throw new LuceneDocumentRetrievalException("Can't fetch document id from lucene index.", e);
                }
            }
        };
    }

    public void close() throws IOException {
        this.searcherReference.close();
    }

    private Document getDocument(int docId) {
        try {
            return this.searcher.doc(docId);
        }
        catch (IOException e) {
            throw new LuceneDocumentRetrievalException("Can't retrieve document with id: " + docId + ".", docId, e);
        }
    }

    private DocIdSetIterator iterateAllDocs() {
        DocIdSetIterator allDocs = DocIdSetIterator.all((int)this.reader.maxDoc());
        if (!this.reader.hasDeletions()) {
            return allDocs;
        }
        return new FilteredDocIdSetIterator(allDocs){
            List<LeafReaderContext> leaves;
            Bits currentLiveDocs;
            int currentMaxDoc;
            {
                this.leaves = LucenePartitionAllDocumentsReader.this.reader.leaves();
                this.currentMaxDoc = -1;
            }

            protected boolean match(int doc) {
                if (doc > this.currentMaxDoc && !this.leaves.isEmpty()) {
                    LeafReaderContext leaf = this.leaves.remove(0);
                    LeafReader reader = leaf.reader();
                    this.currentLiveDocs = reader.getLiveDocs();
                    this.currentMaxDoc = reader.maxDoc();
                }
                return this.currentLiveDocs.get(doc);
            }
        };
    }
}

