/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.reader;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.util.BytesRef;
import org.neo4j.internal.helpers.TaskControl;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.collector.DocValuesCollector;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.TaskCoordinator;
import org.neo4j.kernel.api.impl.schema.ValueEncoding;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.api.impl.schema.reader.LuceneDistinctValuesProgressor;
import org.neo4j.kernel.api.impl.schema.sampler.NonUniqueLuceneIndexSampler;
import org.neo4j.kernel.api.impl.schema.sampler.UniqueLuceneIndexSampler;
import org.neo4j.kernel.api.index.AbstractIndexReader;
import org.neo4j.kernel.api.index.BridgingIndexProgressor;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

public class SimpleIndexReader
extends AbstractIndexReader {
    private final SearcherReference searcherReference;
    private final IndexDescriptor descriptor;
    private final IndexSamplingConfig samplingConfig;
    private final TaskCoordinator taskCoordinator;

    public SimpleIndexReader(SearcherReference searcherReference, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TaskCoordinator taskCoordinator) {
        super(descriptor);
        this.searcherReference = searcherReference;
        this.descriptor = descriptor;
        this.samplingConfig = samplingConfig;
        this.taskCoordinator = taskCoordinator;
    }

    public IndexSampler createSampler() {
        TaskControl taskControl = this.taskCoordinator.newInstance();
        if (this.descriptor.isUnique()) {
            return new UniqueLuceneIndexSampler(this.getIndexSearcher(), taskControl);
        }
        return new NonUniqueLuceneIndexSampler(this.getIndexSearcher(), taskControl, this.samplingConfig);
    }

    public void query(QueryContext context, IndexProgressor.EntityValueClient client, IndexOrder indexOrder, boolean needsValues, IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        Query query = this.toLuceneQuery(predicates);
        client.initialize(this.descriptor, this.search(query).getIndexProgressor("id", client), predicates, indexOrder, needsValues, false);
    }

    private DocValuesCollector search(Query query) {
        try {
            DocValuesCollector docValuesCollector = new DocValuesCollector();
            this.getIndexSearcher().search(query, (Collector)docValuesCollector);
            return docValuesCollector;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Query toLuceneQuery(IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        IndexQuery predicate = predicates[0];
        switch (predicate.type()) {
            case exact: {
                Value[] values = new Value[predicates.length];
                for (int i = 0; i < predicates.length; ++i) {
                    assert (predicates[i].type() == IndexQuery.IndexQueryType.exact) : "Exact followed by another query predicate type is not supported at this moment.";
                    values[i] = ((IndexQuery.ExactPredicate)predicates[i]).value();
                }
                return LuceneDocumentStructure.newSeekQuery(values);
            }
            case exists: {
                for (IndexQuery p : predicates) {
                    if (p.type() == IndexQuery.IndexQueryType.exists) continue;
                    throw new IndexNotApplicableKernelException("Exists followed by another query predicate type is not supported.");
                }
                return LuceneDocumentStructure.newScanQuery();
            }
            case range: {
                this.assertNotComposite(predicates);
                if (predicate.valueGroup() == ValueGroup.TEXT) {
                    IndexQuery.TextRangePredicate sp = (IndexQuery.TextRangePredicate)predicate;
                    return LuceneDocumentStructure.newRangeSeekByStringQuery(sp.from(), sp.fromInclusive(), sp.to(), sp.toInclusive());
                }
                throw new UnsupportedOperationException(String.format("Range scans of value group %s are not supported", predicate.valueGroup()));
            }
            case stringPrefix: {
                this.assertNotComposite(predicates);
                IndexQuery.StringPrefixPredicate spp = (IndexQuery.StringPrefixPredicate)predicate;
                return LuceneDocumentStructure.newRangeSeekByPrefixQuery(spp.prefix().stringValue());
            }
            case stringContains: {
                this.assertNotComposite(predicates);
                IndexQuery.StringContainsPredicate scp = (IndexQuery.StringContainsPredicate)predicate;
                return LuceneDocumentStructure.newWildCardStringQuery(scp.contains().stringValue());
            }
            case stringSuffix: {
                this.assertNotComposite(predicates);
                IndexQuery.StringSuffixPredicate ssp = (IndexQuery.StringSuffixPredicate)predicate;
                return LuceneDocumentStructure.newSuffixStringQuery(ssp.suffix().stringValue());
            }
        }
        throw new RuntimeException("Index query not supported: " + Arrays.toString(predicates));
    }

    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return false;
    }

    public void distinctValues(IndexProgressor.EntityValueClient client, NodePropertyAccessor propertyAccessor, boolean needsValues) {
        try {
            IndexQuery[] noQueries = new IndexQuery[]{};
            BridgingIndexProgressor multiProgressor = new BridgingIndexProgressor(client, this.descriptor.schema().getPropertyIds());
            IndexReader reader = this.getIndexSearcher().getIndexReader();
            List leaves = reader.leaves();
            Fields[] subFields = new Fields[leaves.size()];
            ReaderSlice[] readerSlices = new ReaderSlice[leaves.size()];
            for (int i = 0; i < leaves.size(); ++i) {
                LeafReaderContext context = (LeafReaderContext)leaves.get(i);
                LeafReader leafReader = context.reader();
                subFields[i] = this.fieldsOf(leafReader);
                readerSlices[i] = new ReaderSlice(context.docBase, reader.maxDoc(), i);
            }
            MultiFields fields = new MultiFields(subFields, readerSlices);
            for (ValueEncoding valueEncoding : ValueEncoding.values()) {
                Terms terms = fields.terms(valueEncoding.key());
                if (terms == null) continue;
                Function<BytesRef, Value> valueMaterializer = valueEncoding == ValueEncoding.String && needsValues ? term -> Values.stringValue((String)term.utf8ToString()) : term -> null;
                TermsEnum termsIterator = terms.iterator();
                multiProgressor.initialize(this.descriptor, (IndexProgressor)new LuceneDistinctValuesProgressor(termsIterator, client, valueMaterializer), noQueries, IndexOrder.NONE, needsValues, false);
            }
            client.initialize(this.descriptor, (IndexProgressor)multiProgressor, noQueries, IndexOrder.NONE, needsValues, false);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Fields fieldsOf(final LeafReader leafReader) {
        return new Fields(){

            public Iterator<String> iterator() {
                return StreamSupport.stream(leafReader.getFieldInfos().spliterator(), false).map(info -> info.name).iterator();
            }

            public Terms terms(String field) throws IOException {
                return leafReader.terms(field);
            }

            public int size() {
                return leafReader.getFieldInfos().size();
            }
        };
    }

    private void assertNotComposite(IndexQuery[] predicates) {
        assert (predicates.length == 1) : "composite indexes not yet supported for this operation";
    }

    public long countIndexedNodes(long nodeId, int[] propertyKeyIds, Value ... propertyValues) {
        TermQuery nodeIdQuery = new TermQuery(LuceneDocumentStructure.newTermForChangeOrRemove(nodeId));
        Query valueQuery = LuceneDocumentStructure.newSeekQuery(propertyValues);
        BooleanQuery.Builder nodeIdAndValueQuery = new BooleanQuery.Builder();
        nodeIdAndValueQuery.add((Query)nodeIdQuery, BooleanClause.Occur.MUST);
        nodeIdAndValueQuery.add(valueQuery, BooleanClause.Occur.MUST);
        try {
            TotalHitCountCollector collector = new TotalHitCountCollector();
            this.getIndexSearcher().search((Query)nodeIdAndValueQuery.build(), (Collector)collector);
            return collector.getTotalHits();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.searcherReference.close();
        }
        catch (IOException e) {
            throw new IndexReaderCloseException(e);
        }
    }

    private IndexSearcher getIndexSearcher() {
        return this.searcherReference.getIndexSearcher();
    }
}

