/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.storage;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.api.impl.index.storage.layout.FolderLayout;
import org.neo4j.string.UTF8;

public class FailureStorage {
    private static final int MAX_FAILURE_SIZE = 16384;
    public static final String DEFAULT_FAILURE_FILE_NAME = "failure-message";
    private final FileSystemAbstraction fs;
    private final FolderLayout folderLayout;
    private final String failureFileName;

    public FailureStorage(FileSystemAbstraction fs, FolderLayout folderLayout, String failureFileName) {
        this.fs = fs;
        this.folderLayout = folderLayout;
        this.failureFileName = failureFileName;
    }

    public FailureStorage(FileSystemAbstraction fs, FolderLayout folderLayout) {
        this(fs, folderLayout, DEFAULT_FAILURE_FILE_NAME);
    }

    public synchronized void reserveForIndex() throws IOException {
        this.fs.mkdirs(this.folderLayout.getIndexFolder());
        File failureFile = this.failureFile();
        try (StoreChannel channel = this.fs.write(failureFile);){
            channel.writeAll(ByteBuffer.wrap(new byte[16384]));
            channel.force(true);
        }
    }

    public synchronized void clearForIndex() {
        this.fs.deleteFile(this.failureFile());
    }

    public synchronized String loadIndexFailure() {
        File failureFile = this.failureFile();
        try {
            if (!this.fs.fileExists(failureFile) || !this.isFailed(failureFile)) {
                return null;
            }
            return this.readFailure(failureFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void storeIndexFailure(String failure) throws IOException {
        File failureFile = this.failureFile();
        try (StoreChannel channel = this.fs.write(failureFile);){
            byte[] existingData = new byte[(int)channel.size()];
            channel.readAll(ByteBuffer.wrap(existingData));
            channel.position((long)FailureStorage.lengthOf(existingData));
            byte[] data = UTF8.encode((String)failure);
            channel.writeAll(ByteBuffer.wrap(data, 0, Math.min(data.length, 16384)));
            channel.force(true);
        }
    }

    File failureFile() {
        File folder = this.folderLayout.getIndexFolder();
        return new File(folder, this.failureFileName);
    }

    private String readFailure(File failureFile) throws IOException {
        try (StoreChannel channel = this.fs.read(failureFile);){
            byte[] data = new byte[(int)channel.size()];
            channel.readAll(ByteBuffer.wrap(data));
            String string = UTF8.decode((byte[])FailureStorage.withoutZeros(data));
            return string;
        }
    }

    private static byte[] withoutZeros(byte[] data) {
        byte[] result = new byte[FailureStorage.lengthOf(data)];
        System.arraycopy(data, 0, result, 0, result.length);
        return result;
    }

    private static int lengthOf(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (0 != data[i]) continue;
            return i;
        }
        return data.length;
    }

    private boolean isFailed(File failureFile) throws IOException {
        try (StoreChannel channel = this.fs.read(failureFile);){
            byte[] data = new byte[(int)channel.size()];
            channel.readAll(ByteBuffer.wrap(data));
            channel.close();
            boolean bl = !FailureStorage.allZero(data);
            return bl;
        }
    }

    private static boolean allZero(byte[] data) {
        for (byte b : data) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }
}

