/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.ToLongFunction;
import org.apache.lucene.document.Document;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.LuceneIndexConsistencyCheckVisitor;
import org.neo4j.kernel.api.impl.schema.LuceneIndexReaderAcquisitionException;
import org.neo4j.kernel.api.impl.schema.reader.LuceneAllEntriesIndexAccessorReader;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;

public abstract class AbstractLuceneIndexAccessor<READER extends IndexReader, INDEX extends DatabaseIndex<READER>>
implements IndexAccessor {
    protected final LuceneIndexWriter writer;
    protected final INDEX luceneIndex;
    protected final IndexDescriptor descriptor;

    protected AbstractLuceneIndexAccessor(INDEX luceneIndex, IndexDescriptor descriptor) {
        this.writer = luceneIndex.isReadOnly() ? null : luceneIndex.getIndexWriter();
        this.luceneIndex = luceneIndex;
        this.descriptor = descriptor;
    }

    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        if (this.luceneIndex.isReadOnly()) {
            throw new UnsupportedOperationException("Can't create updater for read only index.");
        }
        return this.getIndexUpdater(mode);
    }

    protected abstract IndexUpdater getIndexUpdater(IndexUpdateMode var1);

    public void drop() {
        this.luceneIndex.drop();
    }

    public void force(IOLimiter ioLimiter) {
        try {
            if (!this.luceneIndex.isReadOnly()) {
                this.luceneIndex.markAsOnline();
            }
            this.luceneIndex.maybeRefreshBlocking();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void refresh() {
        try {
            this.luceneIndex.maybeRefreshBlocking();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void close() {
        try {
            this.luceneIndex.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public READER newReader() {
        try {
            return this.luceneIndex.getIndexReader();
        }
        catch (IOException e) {
            throw new LuceneIndexReaderAcquisitionException("Can't acquire index reader", e);
        }
    }

    public BoundedIterable<Long> newAllEntriesReader(ToLongFunction<Document> entityIdReader, long fromIdInclusive, long toIdExclusive) {
        return new LuceneAllEntriesIndexAccessorReader(this.luceneIndex.allDocumentsReader(), entityIdReader, fromIdInclusive, toIdExclusive);
    }

    public ResourceIterator<File> snapshotFiles() {
        try {
            return this.luceneIndex.snapshot();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public abstract void verifyDeferredConstraints(NodePropertyAccessor var1) throws IndexEntryConflictException;

    public boolean isDirty() {
        return !this.luceneIndex.isValid();
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory) {
        boolean isConsistent;
        LuceneIndexConsistencyCheckVisitor visitor = (LuceneIndexConsistencyCheckVisitor)reporterFactory.getClass(LuceneIndexConsistencyCheckVisitor.class);
        boolean bl = isConsistent = !this.isDirty();
        if (!isConsistent) {
            visitor.isInconsistent(this.descriptor);
        }
        return isConsistent;
    }

    public long estimateNumberOfEntries() {
        return this.luceneIndex.allDocumentsReader().maxCount();
    }

    protected abstract class AbstractLuceneIndexUpdater
    implements IndexUpdater {
        private final boolean idempotent;
        private final boolean refresh;
        private boolean hasChanges;

        protected AbstractLuceneIndexUpdater(boolean idempotent, boolean refresh) {
            this.idempotent = idempotent;
            this.refresh = refresh;
        }

        public void process(IndexEntryUpdate<?> update) {
            assert (update.indexKey().schema().equals(AbstractLuceneIndexAccessor.this.descriptor.schema()));
            switch (update.updateMode()) {
                case ADDED: {
                    if (this.idempotent) {
                        this.addIdempotent(update.getEntityId(), update.values());
                        break;
                    }
                    this.add(update.getEntityId(), update.values());
                    break;
                }
                case CHANGED: {
                    this.change(update.getEntityId(), update.values());
                    break;
                }
                case REMOVED: {
                    this.remove(update.getEntityId());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            this.hasChanges = true;
        }

        public void close() {
            if (this.hasChanges && this.refresh) {
                try {
                    AbstractLuceneIndexAccessor.this.luceneIndex.maybeRefreshBlocking();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }

        protected abstract void addIdempotent(long var1, Value[] var3);

        protected abstract void add(long var1, Value[] var3);

        protected abstract void change(long var1, Value[] var3);

        protected abstract void remove(long var1);
    }
}

