/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.populator.LuceneIndexPopulatingUpdater;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.impl.api.index.sampling.UniqueIndexSampler;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;

public class UniqueLuceneIndexPopulatingUpdater
extends LuceneIndexPopulatingUpdater {
    private final int[] propertyKeyIds;
    private final SchemaIndex luceneIndex;
    private final NodePropertyAccessor nodePropertyAccessor;
    private final UniqueIndexSampler sampler;
    private final List<Value[]> updatedValueTuples = new ArrayList<Value[]>();

    public UniqueLuceneIndexPopulatingUpdater(LuceneIndexWriter writer, int[] propertyKeyIds, SchemaIndex luceneIndex, NodePropertyAccessor nodePropertyAccessor, UniqueIndexSampler sampler) {
        super(writer);
        this.propertyKeyIds = propertyKeyIds;
        this.luceneIndex = luceneIndex;
        this.nodePropertyAccessor = nodePropertyAccessor;
        this.sampler = sampler;
    }

    @Override
    protected void added(IndexEntryUpdate<?> update) {
        this.sampler.increment(1L);
        this.updatedValueTuples.add(update.values());
    }

    @Override
    protected void changed(IndexEntryUpdate<?> update) {
        this.updatedValueTuples.add(update.values());
    }

    @Override
    protected void removed(IndexEntryUpdate<?> update) {
        this.sampler.increment(-1L);
    }

    public void close() throws IndexEntryConflictException {
        try {
            this.luceneIndex.verifyUniqueness(this.nodePropertyAccessor, this.propertyKeyIds, this.updatedValueTuples);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

