/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import org.neo4j.kernel.impl.index.IndexEntityType;

class IndexIdentifier {
    final IndexEntityType entityType;
    final String indexName;
    private final int hashCode;

    IndexIdentifier(IndexEntityType entityType, String indexName) {
        this.entityType = entityType;
        this.indexName = indexName;
        this.hashCode = this.calculateHashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        IndexIdentifier i = (IndexIdentifier)o;
        return this.entityType == i.entityType && this.indexName.equals(i.indexName);
    }

    private int calculateHashCode() {
        int code = 17;
        code += 7 * this.entityType.hashCode();
        return code += 7 * this.indexName.hashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "Index[" + this.indexName + "," + this.entityType.nameToLowerCase() + "]";
    }
}

