/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.populator.LuceneIndexPopulator;
import org.neo4j.kernel.api.impl.schema.populator.UniqueLuceneIndexPopulatingUpdater;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.sampling.UniqueIndexSampler;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexSample;

public class UniqueLuceneIndexPopulator
extends LuceneIndexPopulator<SchemaIndex> {
    private final int[] propertyKeyIds;
    private final UniqueIndexSampler sampler;

    public UniqueLuceneIndexPopulator(SchemaIndex index, IndexDescriptor descriptor) {
        super(index);
        this.propertyKeyIds = descriptor.schema().getPropertyIds();
        this.sampler = new UniqueIndexSampler();
    }

    public void verifyDeferredConstraints(NodePropertyAccessor accessor) throws IndexEntryConflictException {
        try {
            ((SchemaIndex)this.luceneIndex).verifyUniqueness(accessor, this.propertyKeyIds);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor) {
        return new UniqueLuceneIndexPopulatingUpdater(this.writer, this.propertyKeyIds, (SchemaIndex)this.luceneIndex, accessor, this.sampler);
    }

    public void includeSample(IndexEntryUpdate<?> update) {
        this.sampler.increment(1L);
    }

    public IndexSample sampleResult() {
        return this.sampler.result();
    }
}

