/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.impl.schema.IndexProviderFactoryUtil;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProvider;
import org.neo4j.kernel.api.impl.schema.NativeLuceneFusionIndexProviderFactory;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.index.schema.AbstractIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.SpatialIndexProvider;
import org.neo4j.kernel.impl.index.schema.TemporalIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionSlotSelector00;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;

public class LuceneIndexProviderFactory
extends AbstractIndexProviderFactory<Dependencies> {
    private static final GraphDatabaseSettings.SchemaIndex SCHEMA_INDEX = GraphDatabaseSettings.SchemaIndex.LUCENE10;
    private static final String KEY = SCHEMA_INDEX.providerName();
    public static final IndexProvider.Descriptor PROVIDER_DESCRIPTOR = new IndexProvider.Descriptor(KEY, SCHEMA_INDEX.providerVersion());

    public LuceneIndexProviderFactory() {
        super(KEY);
    }

    protected Class loggingClass() {
        return LuceneIndexProvider.class;
    }

    protected String descriptorString() {
        return PROVIDER_DESCRIPTOR.toString();
    }

    protected IndexProvider internalCreate(PageCache pageCache, File storeDir, FileSystemAbstraction fs, IndexProvider.Monitor monitor, Config config, OperationalMode operationalMode, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        return LuceneIndexProviderFactory.newInstance(pageCache, storeDir, fs, monitor, config, operationalMode, recoveryCleanupWorkCollector);
    }

    public static FusionIndexProvider newInstance(PageCache pageCache, File databaseDirectory, FileSystemAbstraction fs, IndexProvider.Monitor monitor, Config config, OperationalMode operationalMode, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        boolean readOnly = IndexProviderFactoryUtil.isReadOnly(config, operationalMode);
        boolean archiveFailedIndex = (Boolean)config.get(GraphDatabaseSettings.archive_failed_index);
        IndexDirectoryStructure.Factory luceneDirStructure = IndexDirectoryStructure.directoriesByProviderKey((File)databaseDirectory);
        IndexDirectoryStructure.Factory childDirectoryStructure = LuceneIndexProviderFactory.subProviderDirectoryStructure(databaseDirectory);
        LuceneIndexProvider lucene = IndexProviderFactoryUtil.luceneProvider(fs, luceneDirStructure, monitor, config, operationalMode);
        TemporalIndexProvider temporal = IndexProviderFactoryUtil.temporalProvider(pageCache, fs, childDirectoryStructure, monitor, recoveryCleanupWorkCollector, readOnly);
        SpatialIndexProvider spatial = IndexProviderFactoryUtil.spatialProvider(pageCache, fs, childDirectoryStructure, monitor, recoveryCleanupWorkCollector, readOnly, config);
        int priority = SCHEMA_INDEX.priority(config);
        return new FusionIndexProvider(IndexProvider.EMPTY, IndexProvider.EMPTY, (IndexProvider)spatial, (IndexProvider)temporal, (IndexProvider)lucene, (SlotSelector)new FusionSlotSelector00(), PROVIDER_DESCRIPTOR, priority, IndexDirectoryStructure.directoriesByProvider((File)databaseDirectory), fs, archiveFailedIndex);
    }

    private static IndexDirectoryStructure.Factory subProviderDirectoryStructure(File databaseDirectory) {
        return NativeLuceneFusionIndexProviderFactory.subProviderDirectoryStructure(databaseDirectory, PROVIDER_DESCRIPTOR);
    }

    public static interface Dependencies
    extends AbstractIndexProviderFactory.Dependencies {
    }
}

