/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.kernel.api.impl.index.AbstractDatabaseIndex;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndex;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.storageengine.api.schema.IndexReader;

public class WritableAbstractDatabaseIndex<INDEX extends AbstractLuceneIndex<READER>, READER extends IndexReader>
extends AbstractDatabaseIndex<INDEX, READER> {
    private final ReentrantLock commitCloseLock = new ReentrantLock();

    public WritableAbstractDatabaseIndex(INDEX luceneIndex) {
        super(luceneIndex);
    }

    @Override
    public void create() throws IOException {
        this.luceneIndex.create();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void drop() {
        this.commitCloseLock.lock();
        try {
            this.luceneIndex.drop();
        }
        finally {
            this.commitCloseLock.unlock();
        }
    }

    @Override
    public void flush() throws IOException {
        this.commitCloseLock.lock();
        try {
            this.luceneIndex.flush(false);
        }
        finally {
            this.commitCloseLock.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.commitCloseLock.lock();
        try {
            this.luceneIndex.close();
        }
        finally {
            this.commitCloseLock.unlock();
        }
    }

    @Override
    public ResourceIterator<File> snapshot() throws IOException {
        this.commitCloseLock.lock();
        try {
            ResourceIterator<File> resourceIterator = this.luceneIndex.snapshot();
            return resourceIterator;
        }
        finally {
            this.commitCloseLock.unlock();
        }
    }

    @Override
    public void maybeRefreshBlocking() throws IOException {
        this.luceneIndex.maybeRefreshBlocking();
    }

    public AbstractIndexPartition addNewPartition() throws IOException {
        return this.luceneIndex.addNewPartition();
    }

    @Override
    public void markAsOnline() throws IOException {
        this.commitCloseLock.lock();
        try {
            this.luceneIndex.markAsOnline();
        }
        finally {
            this.commitCloseLock.unlock();
        }
    }

    @Override
    public LuceneIndexWriter getIndexWriter() {
        return this.luceneIndex.getIndexWriter(this);
    }

    public boolean hasSinglePartition(List<AbstractIndexPartition> partitions) {
        return this.luceneIndex.hasSinglePartition(partitions);
    }

    public AbstractIndexPartition getFirstPartition(List<AbstractIndexPartition> partitions) {
        return this.luceneIndex.getFirstPartition(partitions);
    }
}

