/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.IndexStorageFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexBuilder;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.StoreIndexDescriptor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.participant.SchemaIndexMigrator;
import org.neo4j.util.VisibleForTesting;

public abstract class AbstractLuceneIndexProvider
extends IndexProvider {
    private final IndexStorageFactory indexStorageFactory;
    protected final Config config;
    protected final OperationalMode operationalMode;
    protected final FileSystemAbstraction fileSystem;

    protected AbstractLuceneIndexProvider(IndexProvider.Descriptor descriptor, int priority, IndexDirectoryStructure.Factory directoryStructureFactory, Config config, OperationalMode operationalMode, FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory) {
        super(descriptor, priority, directoryStructureFactory);
        this.config = config;
        this.operationalMode = operationalMode;
        this.fileSystem = fileSystem;
        this.indexStorageFactory = this.buildIndexStorageFactory(fileSystem, directoryFactory);
    }

    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return new SchemaIndexMigrator(fs, (IndexProvider)this);
    }

    public String getPopulationFailure(StoreIndexDescriptor descriptor) throws IllegalStateException {
        String failure = this.getIndexStorage(descriptor.getId()).getStoredIndexFailure();
        if (failure == null) {
            throw new IllegalStateException("Index " + descriptor.getId() + " isn't failed");
        }
        return failure;
    }

    public IndexCapability getCapability() {
        return IndexCapability.NO_CAPABILITY;
    }

    protected PartitionedIndexStorage getIndexStorage(long indexId) {
        return this.indexStorageFactory.indexStorageOf(indexId);
    }

    protected boolean indexIsOnline(PartitionedIndexStorage indexStorage, StoreIndexDescriptor descriptor) throws IOException {
        try (SchemaIndex index = ((LuceneSchemaIndexBuilder)LuceneSchemaIndexBuilder.create((IndexDescriptor)descriptor, this.config).withIndexStorage(indexStorage)).build();){
            if (index.exists()) {
                index.open();
                boolean bl = index.isOnline();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @VisibleForTesting
    protected IndexStorageFactory buildIndexStorageFactory(FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory) {
        return new IndexStorageFactory(directoryFactory, fileSystem, this.directoryStructure());
    }
}

