/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.neo4j.helpers.TaskCoordinator;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndex;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.partition.IndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.WritableDatabaseSchemaIndex;
import org.neo4j.kernel.api.impl.schema.reader.PartitionedIndexReader;
import org.neo4j.kernel.api.impl.schema.reader.SimpleIndexReader;
import org.neo4j.kernel.api.impl.schema.verification.PartitionedUniquenessVerifier;
import org.neo4j.kernel.api.impl.schema.verification.SimpleUniquenessVerifier;
import org.neo4j.kernel.api.impl.schema.verification.UniquenessVerifier;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.impl.schema.writer.PartitionedIndexWriter;
import org.neo4j.kernel.api.index.NodePropertyAccessor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.Value;

class LuceneSchemaIndex
extends AbstractLuceneIndex {
    private static final String KEY_STATUS = "status";
    private static final String ONLINE = "online";
    private static final Map<String, String> ONLINE_COMMIT_USER_DATA = Collections.singletonMap("status", "online");
    private final IndexDescriptor descriptor;
    private final IndexSamplingConfig samplingConfig;
    private final TaskCoordinator taskCoordinator = new TaskCoordinator(10L, TimeUnit.MILLISECONDS);

    LuceneSchemaIndex(PartitionedIndexStorage indexStorage, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, IndexPartitionFactory partitionFactory) {
        super(indexStorage, partitionFactory);
        this.descriptor = descriptor;
        this.samplingConfig = samplingConfig;
    }

    public LuceneIndexWriter getIndexWriter(WritableDatabaseSchemaIndex writableLuceneSchemaIndex) {
        this.ensureOpen();
        return new PartitionedIndexWriter(writableLuceneSchemaIndex);
    }

    public IndexReader getIndexReader() throws IOException {
        this.ensureOpen();
        List<AbstractIndexPartition> partitions = this.getPartitions();
        return this.hasSinglePartition(partitions) ? this.createSimpleReader(partitions) : this.createPartitionedReader(partitions);
    }

    public IndexDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void verifyUniqueness(NodePropertyAccessor accessor, int[] propertyKeyIds) throws IOException, IndexEntryConflictException {
        this.flush(true);
        try (UniquenessVerifier verifier = this.createUniquenessVerifier();){
            verifier.verify(accessor, propertyKeyIds);
        }
    }

    public void verifyUniqueness(NodePropertyAccessor accessor, int[] propertyKeyIds, List<Value[]> updatedValueTuples) throws IOException, IndexEntryConflictException {
        try (UniquenessVerifier verifier = this.createUniquenessVerifier();){
            verifier.verify(accessor, propertyKeyIds, updatedValueTuples);
        }
    }

    @Override
    public void drop() {
        this.taskCoordinator.cancel();
        try {
            this.taskCoordinator.awaitCompletion();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for concurrent tasks to complete.", e);
        }
        super.drop();
    }

    public boolean isOnline() throws IOException {
        this.ensureOpen();
        AbstractIndexPartition partition = this.getFirstPartition(this.getPartitions());
        Directory directory = partition.getDirectory();
        try (DirectoryReader reader = DirectoryReader.open((Directory)directory);){
            Map userData = reader.getIndexCommit().getUserData();
            boolean bl = ONLINE.equals(userData.get(KEY_STATUS));
            return bl;
        }
    }

    public void markAsOnline() throws IOException {
        this.ensureOpen();
        AbstractIndexPartition partition = this.getFirstPartition(this.getPartitions());
        IndexWriter indexWriter = partition.getIndexWriter();
        indexWriter.setCommitData(ONLINE_COMMIT_USER_DATA);
        this.flush(false);
    }

    public void markAsFailed(String failure) throws IOException {
        this.indexStorage.storeIndexFailure(failure);
    }

    private UniquenessVerifier createUniquenessVerifier() throws IOException {
        this.ensureOpen();
        this.maybeRefreshBlocking();
        List<AbstractIndexPartition> partitions = this.getPartitions();
        return this.hasSinglePartition(partitions) ? this.createSimpleUniquenessVerifier(partitions) : this.createPartitionedUniquenessVerifier(partitions);
    }

    private SimpleIndexReader createSimpleReader(List<AbstractIndexPartition> partitions) throws IOException {
        AbstractIndexPartition singlePartition = this.getFirstPartition(partitions);
        return new SimpleIndexReader(singlePartition.acquireSearcher(), this.descriptor, this.samplingConfig, this.taskCoordinator);
    }

    private UniquenessVerifier createSimpleUniquenessVerifier(List<AbstractIndexPartition> partitions) throws IOException {
        AbstractIndexPartition singlePartition = this.getFirstPartition(partitions);
        PartitionSearcher partitionSearcher = singlePartition.acquireSearcher();
        return new SimpleUniquenessVerifier(partitionSearcher);
    }

    private PartitionedIndexReader createPartitionedReader(List<AbstractIndexPartition> partitions) throws IOException {
        List<PartitionSearcher> searchers = LuceneSchemaIndex.acquireSearchers(partitions);
        return new PartitionedIndexReader(searchers, this.descriptor, this.samplingConfig, this.taskCoordinator);
    }

    private UniquenessVerifier createPartitionedUniquenessVerifier(List<AbstractIndexPartition> partitions) throws IOException {
        List<PartitionSearcher> searchers = LuceneSchemaIndex.acquireSearchers(partitions);
        return new PartitionedUniquenessVerifier(searchers);
    }
}

