/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.verification;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;

abstract class DuplicateCheckStrategy {
    DuplicateCheckStrategy() {
    }

    abstract void checkForDuplicate(Value[] var1, long var2) throws IndexEntryConflictException;

    abstract void checkForDuplicate(Value var1, long var2) throws IndexEntryConflictException;

    private static boolean propertyValuesEqual(Value[] properties, Value[] values) {
        if (properties.length != values.length) {
            return false;
        }
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].equals(values[i])) continue;
            return false;
        }
        return true;
    }

    static class BucketsDuplicateCheckStrategy
    extends DuplicateCheckStrategy {
        private static final int BASE_ENTRY_SIZE = 1000;
        private static final int DEFAULT_BUCKETS = 10;
        static final int BUCKET_STRATEGY_ENTRIES_THRESHOLD = 10000;
        private static final int MAX_NUMBER_OF_BUCKETS = 100;
        private final int numberOfBuckets;
        private BucketEntry[] buckets;
        private final int bucketSetSize;

        BucketsDuplicateCheckStrategy() {
            this(10000);
        }

        BucketsDuplicateCheckStrategy(int expectedNumberOfEntries) {
            this.numberOfBuckets = Math.min(100, expectedNumberOfEntries / 1000 + 1);
            this.buckets = new BucketEntry[this.numberOfBuckets];
            this.bucketSetSize = Math.max(100, 10000 / this.numberOfBuckets);
        }

        @Override
        public void checkForDuplicate(Value[] values, long nodeId) throws IndexEntryConflictException {
            BucketEntry current = this.bucketEntrySet(Arrays.hashCode(values), this.bucketSetSize);
            block0: do {
                for (int i = 0; i < this.bucketSetSize; ++i) {
                    Value[] currentValues = (Value[])current.value[i];
                    if (current.nodeId[i] == -1L) {
                        current.value[i] = values;
                        current.nodeId[i] = nodeId;
                        if (i != this.bucketSetSize - 1) break block0;
                        current.next = new BucketEntry(this.bucketSetSize);
                        break block0;
                    }
                    if (!DuplicateCheckStrategy.propertyValuesEqual(values, currentValues)) continue;
                    throw new IndexEntryConflictException(current.nodeId[i], nodeId, currentValues);
                }
            } while ((current = current.next) != null);
        }

        @Override
        void checkForDuplicate(Value propertyValue, long nodeId) throws IndexEntryConflictException {
            BucketEntry current = this.bucketEntrySet(propertyValue.hashCode(), this.bucketSetSize);
            block0: do {
                for (int i = 0; i < this.bucketSetSize; ++i) {
                    Value value = (Value)current.value[i];
                    if (current.nodeId[i] == -1L) {
                        current.value[i] = propertyValue;
                        current.nodeId[i] = nodeId;
                        if (i != this.bucketSetSize - 1) break block0;
                        current.next = new BucketEntry(this.bucketSetSize);
                        break block0;
                    }
                    if (!propertyValue.equals(value)) continue;
                    throw new IndexEntryConflictException(current.nodeId[i], nodeId, new Value[]{value});
                }
            } while ((current = current.next) != null);
        }

        private BucketEntry bucketEntrySet(int hashCode, int entrySetSize) {
            int bucket = Math.abs(hashCode) % this.numberOfBuckets;
            BucketEntry current = this.buckets[bucket];
            if (current == null) {
                this.buckets[bucket] = current = new BucketEntry(entrySetSize);
            }
            return current;
        }

        private static class BucketEntry {
            final Object[] value;
            final long[] nodeId;
            BucketEntry next;

            BucketEntry(int entrySize) {
                this.value = new Object[entrySize];
                this.nodeId = new long[entrySize];
                Arrays.fill(this.nodeId, -1L);
            }
        }
    }

    static class MapDuplicateCheckStrategy
    extends DuplicateCheckStrategy {
        private Map<Object, Long> valueNodeIdMap;

        MapDuplicateCheckStrategy(int expectedNumberOfEntries) {
            this.valueNodeIdMap = new HashMap<Object, Long>(expectedNumberOfEntries);
        }

        @Override
        public void checkForDuplicate(Value[] values, long nodeId) throws IndexEntryConflictException {
            Long previousNodeId = this.valueNodeIdMap.put(ValueTuple.of((Value[])values), nodeId);
            if (previousNodeId != null) {
                throw new IndexEntryConflictException(previousNodeId.longValue(), nodeId, ValueTuple.of((Value[])values));
            }
        }

        @Override
        void checkForDuplicate(Value value, long nodeId) throws IndexEntryConflictException {
            Long previousNodeId = this.valueNodeIdMap.put(value, nodeId);
            if (previousNodeId != null) {
                throw new IndexEntryConflictException(previousNodeId.longValue(), nodeId, new Value[]{value});
            }
        }
    }
}

