/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.impl.schema.IndexProviderFactoryUtil;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProvider;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProviderFactory;
import org.neo4j.kernel.api.impl.schema.NativeLuceneFusionIndexProviderFactory;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.LoggingMonitor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.index.schema.NumberIndexProvider;
import org.neo4j.kernel.impl.index.schema.SpatialIndexProvider;
import org.neo4j.kernel.impl.index.schema.StringIndexProvider;
import org.neo4j.kernel.impl.index.schema.TemporalIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionSelector20;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;

public class NativeLuceneFusionIndexProviderFactory20
extends NativeLuceneFusionIndexProviderFactory<Dependencies> {
    public static final IndexProvider.Descriptor DESCRIPTOR = new IndexProvider.Descriptor("lucene+native", "2.0");
    private static final int PRIORITY = 3;

    public FusionIndexProvider newInstance(KernelContext context, Dependencies dependencies) {
        PageCache pageCache = dependencies.pageCache();
        File storeDir = context.storeDir();
        FileSystemAbstraction fs = dependencies.fileSystem();
        Log log = dependencies.getLogService().getInternalLogProvider().getLog(FusionIndexProvider.class);
        Monitors monitors = dependencies.monitors();
        monitors.addMonitorListener((Object)new LoggingMonitor(log), new String[]{DESCRIPTOR.toString()});
        IndexProvider.Monitor monitor = (IndexProvider.Monitor)monitors.newMonitor(IndexProvider.Monitor.class, new String[]{DESCRIPTOR.toString()});
        Config config = dependencies.getConfig();
        OperationalMode operationalMode = context.databaseInfo().operationalMode;
        RecoveryCleanupWorkCollector recoveryCleanupWorkCollector = dependencies.recoveryCleanupWorkCollector();
        return NativeLuceneFusionIndexProviderFactory20.create(pageCache, storeDir, fs, monitor, config, operationalMode, recoveryCleanupWorkCollector);
    }

    public static FusionIndexProvider create(PageCache pageCache, File storeDir, FileSystemAbstraction fs, IndexProvider.Monitor monitor, Config config, OperationalMode operationalMode, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        IndexDirectoryStructure.Factory childDirectoryStructure = NativeLuceneFusionIndexProviderFactory20.subProviderDirectoryStructure(storeDir);
        boolean readOnly = IndexProviderFactoryUtil.isReadOnly(config, operationalMode);
        boolean archiveFailedIndex = (Boolean)config.get(GraphDatabaseSettings.archive_failed_index);
        StringIndexProvider string = IndexProviderFactoryUtil.stringProvider(pageCache, fs, childDirectoryStructure, monitor, recoveryCleanupWorkCollector, readOnly);
        NumberIndexProvider number = IndexProviderFactoryUtil.numberProvider(pageCache, fs, childDirectoryStructure, monitor, recoveryCleanupWorkCollector, readOnly);
        SpatialIndexProvider spatial = IndexProviderFactoryUtil.spatialProvider(pageCache, fs, childDirectoryStructure, monitor, recoveryCleanupWorkCollector, readOnly, config);
        TemporalIndexProvider temporal = IndexProviderFactoryUtil.temporalProvider(pageCache, fs, childDirectoryStructure, monitor, recoveryCleanupWorkCollector, readOnly);
        LuceneIndexProvider lucene = IndexProviderFactoryUtil.luceneProvider(fs, childDirectoryStructure, monitor, config, operationalMode);
        String defaultSchemaProvider = (String)config.get(GraphDatabaseSettings.default_schema_provider);
        int priority = 3;
        if (GraphDatabaseSettings.SchemaIndex.NATIVE20.providerName().equals(defaultSchemaProvider)) {
            priority = 100;
        }
        return new FusionIndexProvider((IndexProvider)string, (IndexProvider)number, (IndexProvider)spatial, (IndexProvider)temporal, (IndexProvider)lucene, (FusionIndexProvider.Selector)new FusionSelector20(), DESCRIPTOR, priority, IndexDirectoryStructure.directoriesByProvider((File)storeDir), fs, archiveFailedIndex);
    }

    public static IndexDirectoryStructure.Factory subProviderDirectoryStructure(File storeDir) {
        return NativeLuceneFusionIndexProviderFactory.subProviderDirectoryStructure(storeDir, DESCRIPTOR);
    }

    public static interface Dependencies
    extends LuceneIndexProviderFactory.Dependencies {
    }
}

