/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.collection.LruCache;
import org.neo4j.index.impl.lucene.explicit.ConstantScoreIterator;
import org.neo4j.index.impl.lucene.explicit.DocToIdIterator;
import org.neo4j.index.impl.lucene.explicit.EntityId;
import org.neo4j.index.impl.lucene.explicit.IndexIdentifier;
import org.neo4j.index.impl.lucene.explicit.IndexType;
import org.neo4j.index.impl.lucene.explicit.LuceneDataSource;
import org.neo4j.index.lucene.ValueContext;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.ExplicitIndexHits;
import org.neo4j.kernel.api.impl.index.collector.DocValuesCollector;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.unsafe.batchinsert.BatchInserterIndex;

class LuceneBatchInserterIndex
implements BatchInserterIndex {
    private final IndexIdentifier identifier;
    private final IndexType type;
    private IndexWriter writer;
    private SearcherManager searcherManager;
    private final boolean createdNow;
    private Map<String, LruCache<String, Collection<EntityId>>> cache;
    private int updateCount;
    private final int commitBatchSize = 500000;
    private final RelationshipLookup relationshipLookup;

    LuceneBatchInserterIndex(File dbStoreDir, IndexIdentifier identifier, Map<String, String> config, RelationshipLookup relationshipLookup) {
        File storeDir = this.getStoreDir(dbStoreDir);
        this.createdNow = !LuceneDataSource.getFileDirectory(storeDir, identifier).exists();
        this.identifier = identifier;
        this.type = IndexType.getIndexType(config);
        this.relationshipLookup = relationshipLookup;
        this.writer = this.instantiateWriter(storeDir);
        this.searcherManager = LuceneBatchInserterIndex.instantiateSearcherManager(this.writer);
    }

    public void add(long id, Map<String, Object> properties) {
        try {
            Document document = IndexType.newDocument(this.entityId(id));
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                this.addSingleProperty(id, document, key, value);
            }
            this.writer.addDocument((Iterable)document);
            if (++this.updateCount == 500000) {
                this.writer.commit();
                this.updateCount = 0;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private EntityId entityId(long id) {
        if (this.identifier.entityType == IndexEntityType.Node) {
            return new EntityId.IdData(id);
        }
        return this.relationshipLookup.lookup(id);
    }

    private void addSingleProperty(long entityId, Document document, String key, Object value) {
        for (Object oneValue : IoPrimitiveUtils.asArray((Object)value)) {
            boolean isValueContext = oneValue instanceof ValueContext;
            oneValue = isValueContext ? ((ValueContext)oneValue).getCorrectValue() : oneValue.toString();
            this.type.addToDocument(document, key, oneValue);
            if (!this.createdNow) continue;
            this.addToCache(entityId, key, oneValue);
        }
    }

    private void addToCache(long entityId, String key, Object value) {
        if (this.cache == null) {
            return;
        }
        String valueAsString = value.toString();
        LruCache<String, Collection<EntityId>> cache = this.cache.get(key);
        if (cache != null) {
            HashSet<EntityId.IdData> ids = (HashSet<EntityId.IdData>)cache.get((Object)valueAsString);
            if (ids == null) {
                ids = new HashSet<EntityId.IdData>();
                cache.put((Object)valueAsString, ids);
            }
            ids.add(new EntityId.IdData(entityId));
        }
    }

    private void addToCache(Collection<EntityId> ids, String key, Object value) {
        if (this.cache == null) {
            return;
        }
        String valueAsString = value.toString();
        LruCache<String, Collection<EntityId>> cache = this.cache.get(key);
        if (cache != null) {
            cache.put((Object)valueAsString, ids);
        }
    }

    private ExplicitIndexHits getFromCache(String key, Object value) {
        Collection ids;
        if (this.cache == null) {
            return null;
        }
        String valueAsString = value.toString();
        LruCache<String, Collection<EntityId>> cache = this.cache.get(key);
        if (cache != null && (ids = (Collection)cache.get((Object)valueAsString)) != null) {
            return new ConstantScoreIterator(ids, Float.NaN);
        }
        return null;
    }

    public void updateOrAdd(long entityId, Map<String, Object> properties) {
        try {
            this.removeFromCache(entityId);
            this.writer.deleteDocuments(new Query[]{this.type.idTermQuery(entityId)});
            this.add(entityId, properties);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromCache(long entityId) throws IOException {
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            Query query = this.type.idTermQuery(entityId);
            TopDocs docs = searcher.search(query, 1);
            if (docs.totalHits > 0) {
                Document document = searcher.doc(docs.scoreDocs[0].doc);
                for (IndexableField field : document.getFields()) {
                    String key = field.name();
                    String value = field.stringValue();
                    this.removeFromCache(entityId, key, value);
                }
            }
        }
        finally {
            this.searcherManager.release((Object)searcher);
        }
    }

    private void removeFromCache(long entityId, String key, Object value) {
        Collection ids;
        if (this.cache == null) {
            return;
        }
        String valueAsString = value.toString();
        LruCache<String, Collection<EntityId>> cache = this.cache.get(key);
        if (cache != null && (ids = (Collection)cache.get((Object)valueAsString)) != null) {
            ids.remove(new EntityId.IdData(entityId));
        }
    }

    private IndexWriter instantiateWriter(File folder) {
        Directory dir = null;
        try {
            dir = LuceneDataSource.getDirectory(folder, this.identifier);
            IndexWriterConfig writerConfig = new IndexWriterConfig(this.type.analyzer);
            writerConfig.setRAMBufferSizeMB(this.determineGoodBufferSize(writerConfig.getRAMBufferSizeMB()));
            return new IndexWriter(dir, writerConfig);
        }
        catch (IOException e) {
            IOUtils.closeAllSilently((AutoCloseable[])new Directory[]{dir});
            throw new RuntimeException(e);
        }
    }

    private double determineGoodBufferSize(double atLeast) {
        double heapHint = Runtime.getRuntime().maxMemory() / 0xE00000L;
        double result = Math.max(atLeast, heapHint);
        return Math.min(result, 700.0);
    }

    private static SearcherManager instantiateSearcherManager(IndexWriter writer) {
        try {
            return new SearcherManager(writer, true, new SearcherFactory());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void closeSearcher() {
        try {
            if (this.searcherManager != null) {
                this.searcherManager.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.searcherManager = null;
        }
    }

    private void closeWriter() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.writer = null;
        }
    }

    private IndexHits<Long> query(Query query, final String key, final Object value) {
        IndexSearcher searcher;
        try {
            searcher = (IndexSearcher)this.searcherManager.acquire();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            DocValuesCollector collector = new DocValuesCollector(true);
            searcher.search(query, (Collector)collector);
            IndexHits<Document> result = collector.getIndexHits(Sort.RELEVANCE);
            DocToIdIterator primitiveHits = null;
            primitiveHits = key == null || this.cache == null || !this.cache.containsKey(key) ? new DocToIdIterator(result, Collections.emptyList(), null, PrimitiveLongCollections.emptySet()) : new DocToIdIterator(result, Collections.emptyList(), null, PrimitiveLongCollections.emptySet()){
                private final Collection<EntityId> ids;
                {
                    super((IndexHits<Document>)source, exclude, searcherOrNull, idsModifiedInTransactionState);
                    this.ids = new ArrayList<EntityId>();
                }

                @Override
                protected boolean fetchNext() {
                    if (super.fetchNext()) {
                        this.ids.add(new EntityId.IdData(this.next));
                        return true;
                    }
                    LuceneBatchInserterIndex.this.addToCache(this.ids, key, value);
                    return false;
                }
            };
            IndexHits<Long> indexHits = this.wrapIndexHits(primitiveHits);
            return indexHits;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.searcherManager.release((Object)searcher);
            }
            catch (IOException iOException) {}
        }
    }

    private IndexHits<Long> wrapIndexHits(final ExplicitIndexHits ids) {
        return new IndexHits<Long>(){

            public boolean hasNext() {
                return ids.hasNext();
            }

            public Long next() {
                return ids.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public ResourceIterator<Long> iterator() {
                return this;
            }

            public int size() {
                return ids.size();
            }

            public void close() {
                ids.close();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Long getSingle() {
                try {
                    long singleId = PrimitiveLongCollections.single((PrimitiveLongIterator)ids, (long)-1L);
                    Long l = singleId == -1L ? null : Long.valueOf(singleId);
                    return l;
                }
                finally {
                    this.close();
                }
            }

            public float currentScore() {
                return 0.0f;
            }
        };
    }

    public IndexHits<Long> get(String key, Object value) {
        ExplicitIndexHits cached = this.getFromCache(key, value);
        return cached != null ? this.wrapIndexHits(cached) : this.query(this.type.get(key, value), key, value);
    }

    public IndexHits<Long> query(String key, Object queryOrQueryObject) {
        return this.query(this.type.query(key, queryOrQueryObject, null), null, null);
    }

    public IndexHits<Long> query(Object queryOrQueryObject) {
        return this.query(this.type.query(null, queryOrQueryObject, null), null, null);
    }

    public void shutdown() {
        this.closeSearcher();
        this.closeWriter();
    }

    private File getStoreDir(File dbStoreDir) {
        File dir = new File(dbStoreDir, "index");
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Unable to create directory path[" + dir.getAbsolutePath() + "] for Neo4j store.");
        }
        return dir;
    }

    public void flush() {
        try {
            this.searcherManager.maybeRefreshBlocking();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setCacheCapacity(String key, int size) {
        LruCache cache;
        if (this.cache == null) {
            this.cache = new HashMap<String, LruCache<String, Collection<EntityId>>>();
        }
        if ((cache = this.cache.get(key)) != null) {
            cache.resize(size);
        } else {
            cache = new LruCache("Batch inserter cache for " + key, size);
            this.cache.put(key, (LruCache<String, Collection<EntityId>>)cache);
        }
    }

    static interface RelationshipLookup {
        public EntityId lookup(long var1);
    }
}

