/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.reader;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TotalHitCountCollector;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.helpers.TaskControl;
import org.neo4j.helpers.TaskCoordinator;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.impl.index.collector.DocValuesCollector;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.api.impl.schema.sampler.NonUniqueLuceneIndexSampler;
import org.neo4j.kernel.api.impl.schema.sampler.UniqueLuceneIndexSampler;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.Value;

public class SimpleIndexReader
implements IndexReader {
    private final PartitionSearcher partitionSearcher;
    private final IndexDescriptor descriptor;
    private final IndexSamplingConfig samplingConfig;
    private final TaskCoordinator taskCoordinator;

    public SimpleIndexReader(PartitionSearcher partitionSearcher, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TaskCoordinator taskCoordinator) {
        this.partitionSearcher = partitionSearcher;
        this.descriptor = descriptor;
        this.samplingConfig = samplingConfig;
        this.taskCoordinator = taskCoordinator;
    }

    public IndexSampler createSampler() {
        TaskControl taskControl = this.taskCoordinator.newInstance();
        if (this.descriptor.type() == IndexDescriptor.Type.UNIQUE) {
            return new UniqueLuceneIndexSampler(this.getIndexSearcher(), taskControl);
        }
        return new NonUniqueLuceneIndexSampler(this.getIndexSearcher(), taskControl, this.samplingConfig);
    }

    public PrimitiveLongResourceIterator query(IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        PrimitiveLongIterator result;
        IndexQuery predicate = predicates[0];
        switch (predicate.type()) {
            case exact: {
                Value[] values = new Value[predicates.length];
                for (int i = 0; i < predicates.length; ++i) {
                    assert (predicates[i].type() == IndexQuery.IndexQueryType.exact) : "Exact followed by another query predicate type is not supported at this moment.";
                    values[i] = ((IndexQuery.ExactPredicate)predicates[i]).value();
                }
                result = this.seek(values);
                break;
            }
            case exists: {
                for (IndexQuery p : predicates) {
                    if (p.type() == IndexQuery.IndexQueryType.exists) continue;
                    throw new IndexNotApplicableKernelException("Exists followed by another query predicate type is not supported.");
                }
                result = this.scan();
                break;
            }
            case rangeNumeric: {
                this.assertNotComposite(predicates);
                IndexQuery.NumberRangePredicate np = (IndexQuery.NumberRangePredicate)predicate;
                result = this.rangeSeekByNumberInclusive(np.from(), np.to());
                break;
            }
            case rangeString: {
                this.assertNotComposite(predicates);
                IndexQuery.StringRangePredicate sp = (IndexQuery.StringRangePredicate)predicate;
                result = this.rangeSeekByString(sp.from(), sp.fromInclusive(), sp.to(), sp.toInclusive());
                break;
            }
            case stringPrefix: {
                this.assertNotComposite(predicates);
                IndexQuery.StringPrefixPredicate spp = (IndexQuery.StringPrefixPredicate)predicate;
                result = this.rangeSeekByPrefix(spp.prefix());
                break;
            }
            case stringContains: {
                this.assertNotComposite(predicates);
                IndexQuery.StringContainsPredicate scp = (IndexQuery.StringContainsPredicate)predicate;
                result = this.containsString(scp.contains());
                break;
            }
            case stringSuffix: {
                this.assertNotComposite(predicates);
                IndexQuery.StringSuffixPredicate ssp = (IndexQuery.StringSuffixPredicate)predicate;
                result = this.endsWith(ssp.suffix());
                break;
            }
            default: {
                throw new RuntimeException("Index query not supported: " + Arrays.toString(predicates));
            }
        }
        return PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)result, null);
    }

    public boolean hasFullNumberPrecision(IndexQuery ... predicates) {
        return false;
    }

    private void assertNotComposite(IndexQuery[] predicates) {
        assert (predicates.length == 1) : "composite indexes not yet supported for this operation";
    }

    private PrimitiveLongIterator seek(Value ... values) {
        return this.query(LuceneDocumentStructure.newSeekQuery(values));
    }

    private PrimitiveLongIterator rangeSeekByNumberInclusive(Number lower, Number upper) {
        return this.query((Query)LuceneDocumentStructure.newInclusiveNumericRangeSeekQuery(lower, upper));
    }

    private PrimitiveLongIterator rangeSeekByString(String lower, boolean includeLower, String upper, boolean includeUpper) {
        return this.query(LuceneDocumentStructure.newRangeSeekByStringQuery(lower, includeLower, upper, includeUpper));
    }

    private PrimitiveLongIterator rangeSeekByPrefix(String prefix) {
        return this.query(LuceneDocumentStructure.newRangeSeekByPrefixQuery(prefix));
    }

    private PrimitiveLongIterator scan() {
        return this.query((Query)LuceneDocumentStructure.newScanQuery());
    }

    private PrimitiveLongIterator containsString(String exactTerm) {
        return this.query(LuceneDocumentStructure.newWildCardStringQuery(exactTerm));
    }

    private PrimitiveLongIterator endsWith(String suffix) {
        return this.query(LuceneDocumentStructure.newSuffixStringQuery(suffix));
    }

    public long countIndexedNodes(long nodeId, Value ... propertyValues) {
        TermQuery nodeIdQuery = new TermQuery(LuceneDocumentStructure.newTermForChangeOrRemove(nodeId));
        Query valueQuery = LuceneDocumentStructure.newSeekQuery(propertyValues);
        BooleanQuery.Builder nodeIdAndValueQuery = new BooleanQuery.Builder().setDisableCoord(true);
        nodeIdAndValueQuery.add((Query)nodeIdQuery, BooleanClause.Occur.MUST);
        nodeIdAndValueQuery.add(valueQuery, BooleanClause.Occur.MUST);
        try {
            TotalHitCountCollector collector = new TotalHitCountCollector();
            this.getIndexSearcher().search((Query)nodeIdAndValueQuery.build(), (Collector)collector);
            return collector.getTotalHits();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.partitionSearcher.close();
        }
        catch (IOException e) {
            throw new IndexReaderCloseException(e);
        }
    }

    protected PrimitiveLongIterator query(Query query) {
        try {
            DocValuesCollector docValuesCollector = new DocValuesCollector();
            this.getIndexSearcher().search(query, (Collector)docValuesCollector);
            return docValuesCollector.getValuesIterator("id");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private IndexSearcher getIndexSearcher() {
        return this.partitionSearcher.getIndexSearcher();
    }
}

