/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.LuceneIndexReaderAcquisitionException;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.reader.LuceneAllEntriesIndexAccessorReader;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.Value;

public class LuceneIndexAccessor
implements IndexAccessor {
    private final LuceneIndexWriter writer;
    private final SchemaIndex luceneIndex;
    private final IndexDescriptor descriptor;

    public LuceneIndexAccessor(SchemaIndex luceneIndex, IndexDescriptor descriptor) throws IOException {
        this.luceneIndex = luceneIndex;
        this.descriptor = descriptor;
        this.writer = luceneIndex.isReadOnly() ? null : luceneIndex.getIndexWriter();
    }

    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        if (this.luceneIndex.isReadOnly()) {
            throw new UnsupportedOperationException("Can't create updater for read only index.");
        }
        return new LuceneIndexUpdater(mode.requiresIdempotency(), mode.requiresRefresh());
    }

    public void drop() throws IOException {
        this.luceneIndex.drop();
    }

    public void force() throws IOException {
        if (!this.luceneIndex.isReadOnly()) {
            this.luceneIndex.markAsOnline();
        }
        this.luceneIndex.maybeRefreshBlocking();
    }

    public void refresh() throws IOException {
        this.luceneIndex.maybeRefreshBlocking();
    }

    public void close() throws IOException {
        this.luceneIndex.close();
    }

    public IndexReader newReader() {
        try {
            return this.luceneIndex.getIndexReader();
        }
        catch (IOException e) {
            throw new LuceneIndexReaderAcquisitionException("Can't acquire index reader", e);
        }
    }

    public BoundedIterable<Long> newAllEntriesReader() {
        return new LuceneAllEntriesIndexAccessorReader(this.luceneIndex.allDocumentsReader());
    }

    public ResourceIterator<File> snapshotFiles() throws IOException {
        return this.luceneIndex.snapshot();
    }

    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
        this.luceneIndex.verifyUniqueness(propertyAccessor, this.descriptor.schema().getPropertyIds());
    }

    private class LuceneIndexUpdater
    implements IndexUpdater {
        private final boolean idempotent;
        private final boolean refresh;
        private boolean hasChanges;

        private LuceneIndexUpdater(boolean idempotent, boolean refresh) {
            this.idempotent = idempotent;
            this.refresh = refresh;
        }

        public void process(IndexEntryUpdate<?> update) throws IOException {
            assert (update.indexKey().schema().equals((Object)LuceneIndexAccessor.this.descriptor.schema()));
            switch (update.updateMode()) {
                case ADDED: {
                    if (this.idempotent) {
                        this.addIdempotent(update.getEntityId(), update.values());
                        break;
                    }
                    this.add(update.getEntityId(), update.values());
                    break;
                }
                case CHANGED: {
                    this.change(update.getEntityId(), update.values());
                    break;
                }
                case REMOVED: {
                    this.remove(update.getEntityId());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            this.hasChanges = true;
        }

        public void close() throws IOException, IndexEntryConflictException {
            if (this.hasChanges && this.refresh) {
                LuceneIndexAccessor.this.luceneIndex.maybeRefreshBlocking();
            }
        }

        private void addIdempotent(long nodeId, Value[] values) throws IOException {
            LuceneIndexAccessor.this.writer.updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove(nodeId), LuceneDocumentStructure.documentRepresentingProperties(nodeId, values));
        }

        private void add(long nodeId, Value[] values) throws IOException {
            LuceneIndexAccessor.this.writer.addDocument(LuceneDocumentStructure.documentRepresentingProperties(nodeId, values));
        }

        private void change(long nodeId, Value[] values) throws IOException {
            LuceneIndexAccessor.this.writer.updateDocument(LuceneDocumentStructure.newTermForChangeOrRemove(nodeId), LuceneDocumentStructure.documentRepresentingProperties(nodeId, values));
        }

        protected void remove(long nodeId) throws IOException {
            LuceneIndexAccessor.this.writer.deleteDocuments(LuceneDocumentStructure.newTermForChangeOrRemove(nodeId));
        }
    }
}

