/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.verification;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.document.Document;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.verification.DuplicateCheckingCollector;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.schema.OrderedPropertyValues;

public class CompositeDuplicateCheckingCollector
extends DuplicateCheckingCollector {
    private final int[] propertyKeyIds;
    private CompositeEntrySet actualValues;

    public CompositeDuplicateCheckingCollector(PropertyAccessor accessor, int[] propertyKeyIds) {
        super(accessor, -1);
        this.propertyKeyIds = propertyKeyIds;
        this.actualValues = new CompositeEntrySet();
    }

    @Override
    protected void doCollect(int doc) throws IOException, KernelException, IndexEntryConflictException {
        Document document = this.reader.document(doc);
        long nodeId = LuceneDocumentStructure.getNodeId(document);
        Property[] properties = new Property[this.propertyKeyIds.length];
        Object[] values = new Object[this.propertyKeyIds.length];
        for (int i = 0; i < properties.length; ++i) {
            properties[i] = this.accessor.getProperty(nodeId, this.propertyKeyIds[i]);
            values[i] = properties[i].value();
        }
        CompositeEntrySet current = this.actualValues;
        block1: do {
            for (int i = 0; i < 10000; ++i) {
                Object[] currentValues = current.values[i];
                if (current.nodeId[i] == -1L) {
                    current.values[i] = values;
                    current.nodeId[i] = nodeId;
                    if (i != 9999) break block1;
                    current.next = new CompositeEntrySet();
                    break block1;
                }
                if (!this.propertyValuesEqual(properties, currentValues)) continue;
                throw new IndexEntryConflictException(current.nodeId[i], nodeId, OrderedPropertyValues.ofUndefined((Object[])currentValues));
            }
        } while ((current = current.next) != null);
    }

    private boolean propertyValuesEqual(Property[] properties, Object[] values) {
        if (properties.length != values.length) {
            return false;
        }
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].valueEquals(values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean needsScores() {
        return false;
    }

    @Override
    public void reset() {
        this.actualValues = new CompositeEntrySet();
    }

    private static class CompositeEntrySet {
        static final int INCREMENT = 10000;
        Object[][] values = new Object[10000][];
        long[] nodeId = new long[10000];
        CompositeEntrySet next;

        CompositeEntrySet() {
            Arrays.fill(this.nodeId, -1L);
        }
    }
}

