/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.populator.LuceneIndexPopulatingUpdater;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.api.index.sampling.UniqueIndexSampler;

public class UniqueLuceneIndexPopulatingUpdater
extends LuceneIndexPopulatingUpdater {
    private final int[] propertyKeyIds;
    private final SchemaIndex luceneIndex;
    private final PropertyAccessor propertyAccessor;
    private final UniqueIndexSampler sampler;
    private final List<Object> updatedPropertyValues = new ArrayList<Object>();

    public UniqueLuceneIndexPopulatingUpdater(LuceneIndexWriter writer, int[] propertyKeyIds, SchemaIndex luceneIndex, PropertyAccessor propertyAccessor, UniqueIndexSampler sampler) {
        super(writer);
        this.propertyKeyIds = propertyKeyIds;
        this.luceneIndex = luceneIndex;
        this.propertyAccessor = propertyAccessor;
        this.sampler = sampler;
    }

    @Override
    protected void added(IndexEntryUpdate update) {
        this.sampler.increment(1L);
        this.updatedPropertyValues.add(update.values()[0]);
    }

    @Override
    protected void changed(IndexEntryUpdate update) {
        this.updatedPropertyValues.add(update.values()[0]);
    }

    @Override
    protected void removed(IndexEntryUpdate update) {
        this.sampler.increment(-1L);
    }

    public void close() throws IOException, IndexEntryConflictException {
        this.luceneIndex.verifyUniqueness(this.propertyAccessor, this.propertyKeyIds, this.updatedPropertyValues);
    }
}

