/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndex;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.partition.IndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.labelscan.WritableDatabaseLabelScanIndex;
import org.neo4j.kernel.api.impl.labelscan.reader.PartitionedLuceneLabelScanStoreReader;
import org.neo4j.kernel.api.impl.labelscan.reader.SimpleLuceneLabelScanStoreReader;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.BitmapDocumentFormat;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.LabelScanStorageStrategy;
import org.neo4j.kernel.api.impl.labelscan.storestrategy.NodeRangeDocumentLabelScanStorageStrategy;
import org.neo4j.kernel.api.impl.labelscan.writer.PartitionedLuceneLabelScanWriter;
import org.neo4j.kernel.api.labelscan.AllEntriesLabelScanReader;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.storageengine.api.schema.LabelScanReader;

class LuceneLabelScanIndex
extends AbstractLuceneIndex {
    private final BitmapDocumentFormat format;
    private final LabelScanStorageStrategy storageStrategy;

    LuceneLabelScanIndex(PartitionedIndexStorage indexStorage, IndexPartitionFactory partitionFactory, BitmapDocumentFormat format) {
        super(indexStorage, partitionFactory);
        this.format = format;
        this.storageStrategy = new NodeRangeDocumentLabelScanStorageStrategy(format);
    }

    public LabelScanReader getLabelScanReader() {
        this.ensureOpen();
        try {
            List<AbstractIndexPartition> partitions = this.getPartitions();
            return this.hasSinglePartition(partitions) ? this.createSimpleReader(partitions) : this.createPartitionedReader(partitions);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public LabelScanWriter getLabelScanWriter(WritableDatabaseLabelScanIndex labelScanIndex) {
        this.ensureOpen();
        return new PartitionedLuceneLabelScanWriter(labelScanIndex, this.format);
    }

    public AllEntriesLabelScanReader allNodeLabelRanges() {
        return this.storageStrategy.newNodeLabelReader(this.allDocumentsReader());
    }

    private LabelScanReader createSimpleReader(List<AbstractIndexPartition> partitions) throws IOException {
        AbstractIndexPartition partition = this.getFirstPartition(partitions);
        PartitionSearcher searcher = partition.acquireSearcher();
        return new SimpleLuceneLabelScanStoreReader(searcher, this.storageStrategy);
    }

    private LabelScanReader createPartitionedReader(List<AbstractIndexPartition> partitions) throws IOException {
        List<PartitionSearcher> searchers = LuceneLabelScanIndex.acquireSearchers(partitions);
        return new PartitionedLuceneLabelScanStoreReader(searchers, this.storageStrategy);
    }
}

