/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.builder;

import java.io.File;
import java.util.Objects;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;

public class LuceneIndexStorageBuilder {
    private DirectoryFactory directoryFactory = DirectoryFactory.PERSISTENT;
    private FileSystemAbstraction fileSystem;
    private File indexRootFolder;
    private String indexIdentifier;
    private PartitionedIndexStorage indexStorage;
    private boolean archiveFailed;

    private LuceneIndexStorageBuilder() {
    }

    public static LuceneIndexStorageBuilder create() {
        return new LuceneIndexStorageBuilder();
    }

    public PartitionedIndexStorage build() {
        if (this.indexStorage == null) {
            Objects.requireNonNull(this.directoryFactory);
            Objects.requireNonNull(this.fileSystem);
            Objects.requireNonNull(this.indexRootFolder);
            Objects.requireNonNull(this.indexIdentifier);
            this.indexStorage = new PartitionedIndexStorage(this.directoryFactory, this.fileSystem, this.indexRootFolder, this.indexIdentifier, this.archiveFailed);
        }
        return this.indexStorage;
    }

    public LuceneIndexStorageBuilder withIndexIdentifier(String indexIdentifier) {
        this.indexIdentifier = indexIdentifier;
        return this;
    }

    public LuceneIndexStorageBuilder withDirectoryFactory(DirectoryFactory directoryFactory) {
        this.directoryFactory = directoryFactory;
        return this;
    }

    public LuceneIndexStorageBuilder withFileSystem(FileSystemAbstraction fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    public LuceneIndexStorageBuilder withIndexRootFolder(File indexRootFolder) {
        this.indexRootFolder = indexRootFolder;
        return this;
    }

    public LuceneIndexStorageBuilder withIndexStorage(PartitionedIndexStorage indexStorage) {
        this.indexStorage = indexStorage;
        return this;
    }

    public LuceneIndexStorageBuilder archivingFailed(boolean archiveFailed) {
        this.archiveFailed = archiveFailed;
        return this;
    }
}

