/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndex;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.LuceneAllDocumentsReader;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;

public abstract class ReadOnlyAbstractDatabaseIndex<T extends AbstractLuceneIndex>
implements DatabaseIndex {
    protected T luceneIndex;

    public ReadOnlyAbstractDatabaseIndex(T luceneIndex) {
        this.luceneIndex = luceneIndex;
    }

    @Override
    public void create() throws IOException {
        throw new UnsupportedOperationException("Index creation in read only mode is not supported.");
    }

    @Override
    public void open() throws IOException {
        ((AbstractLuceneIndex)this.luceneIndex).open();
    }

    @Override
    public boolean isOpen() {
        return ((AbstractLuceneIndex)this.luceneIndex).isOpen();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean exists() throws IOException {
        return ((AbstractLuceneIndex)this.luceneIndex).exists();
    }

    @Override
    public boolean isValid() {
        return ((AbstractLuceneIndex)this.luceneIndex).isValid();
    }

    @Override
    public void drop() throws IOException {
        throw new UnsupportedOperationException("Index drop is not supported in read only mode.");
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        ((AbstractLuceneIndex)this.luceneIndex).close();
    }

    @Override
    public LuceneAllDocumentsReader allDocumentsReader() {
        return ((AbstractLuceneIndex)this.luceneIndex).allDocumentsReader();
    }

    @Override
    public ResourceIterator<File> snapshot() throws IOException {
        return ((AbstractLuceneIndex)this.luceneIndex).snapshot();
    }

    @Override
    public void maybeRefreshBlocking() throws IOException {
    }

    @Override
    public List<AbstractIndexPartition> getPartitions() {
        return ((AbstractLuceneIndex)this.luceneIndex).getPartitions();
    }
}

