/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.impl.lucene.legacy.IndexType;
import org.neo4j.index.impl.lucene.legacy.LuceneCommandApplier;
import org.neo4j.index.impl.lucene.legacy.LuceneDataSource;
import org.neo4j.index.impl.lucene.legacy.LuceneLegacyIndexTransaction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.spi.legacyindex.IndexCommandFactory;
import org.neo4j.kernel.spi.legacyindex.IndexImplementation;
import org.neo4j.kernel.spi.legacyindex.LegacyIndexProviderTransaction;

public class LuceneIndexImplementation
extends LifecycleAdapter
implements IndexImplementation {
    static final String KEY_TYPE = "type";
    static final String KEY_ANALYZER = "analyzer";
    static final String KEY_TO_LOWER_CASE = "to_lower_case";
    static final String KEY_SIMILARITY = "similarity";
    public static final String SERVICE_NAME = "lucene";
    public static final Map<String, String> EXACT_CONFIG = Collections.unmodifiableMap(MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "exact"}));
    public static final Map<String, String> FULLTEXT_CONFIG = Collections.unmodifiableMap(MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "fulltext", "to_lower_case", "true"}));
    private LuceneDataSource dataSource;
    private final File storeDir;
    private final Config config;
    private final Supplier<IndexConfigStore> indexStore;
    private final FileSystemAbstraction fileSystemAbstraction;

    public LuceneIndexImplementation(File storeDir, Config config, Supplier<IndexConfigStore> indexStore, FileSystemAbstraction fileSystemAbstraction) {
        this.storeDir = storeDir;
        this.config = config;
        this.indexStore = indexStore;
        this.fileSystemAbstraction = fileSystemAbstraction;
    }

    public void init() throws Throwable {
        this.dataSource = new LuceneDataSource(this.storeDir, this.config, this.indexStore.get(), this.fileSystemAbstraction);
        this.dataSource.init();
    }

    public void start() throws Throwable {
        this.dataSource.start();
    }

    public void stop() throws Throwable {
        this.dataSource.stop();
    }

    public void shutdown() throws Throwable {
        this.dataSource.shutdown();
        this.dataSource = null;
    }

    public File getIndexImplementationDirectory(File storeDir) {
        return LuceneDataSource.getLuceneIndexStoreDirectory(storeDir);
    }

    public LegacyIndexProviderTransaction newTransaction(IndexCommandFactory commandFactory) {
        return new LuceneLegacyIndexTransaction(this.dataSource, commandFactory);
    }

    public Map<String, String> fillInDefaults(Map<String, String> source) {
        HashMap<String, String> result = source != null ? new HashMap<String, String>(source) : new HashMap();
        String analyzer = (String)result.get(KEY_ANALYZER);
        if (analyzer == null) {
            String type = (String)result.get(KEY_TYPE);
            if (type == null) {
                type = "exact";
                result.put(KEY_TYPE, type);
            }
            if (type.equals("fulltext") && !result.containsKey(KEY_TO_LOWER_CASE)) {
                result.put(KEY_TO_LOWER_CASE, "true");
            }
        }
        IndexType.getIndexType(result);
        return result;
    }

    public boolean configMatches(Map<String, String> storedConfig, Map<String, String> config) {
        return this.match(storedConfig, config, KEY_TYPE, null) && this.match(storedConfig, config, KEY_TO_LOWER_CASE, "true") && this.match(storedConfig, config, KEY_ANALYZER, null) && this.match(storedConfig, config, KEY_SIMILARITY, null);
    }

    private boolean match(Map<String, String> storedConfig, Map<String, String> config, String key, String defaultValue) {
        String value1 = storedConfig.get(key);
        String value2 = config.get(key);
        if (value1 == null || value2 == null) {
            if (value1 == value2) {
                return true;
            }
            if (defaultValue != null) {
                value1 = value1 != null ? value1 : defaultValue;
                value2 = value2 != null ? value2 : defaultValue;
                return value1.equals(value2);
            }
        } else {
            return value1.equals(value2);
        }
        return false;
    }

    public TransactionApplier newApplier(boolean recovery) {
        return new LuceneCommandApplier(this.dataSource, recovery);
    }

    public ResourceIterator<File> listStoreFiles() throws IOException {
        return this.dataSource.listStoreFiles();
    }

    public void force() {
        this.dataSource.force();
    }
}

