/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.SchemaIndex;
import org.neo4j.kernel.api.impl.schema.populator.LuceneIndexPopulator;
import org.neo4j.kernel.api.impl.schema.populator.UniqueLuceneIndexPopulatingUpdater;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.UniqueIndexSampler;
import org.neo4j.storageengine.api.schema.IndexSample;

public class UniqueLuceneIndexPopulator
extends LuceneIndexPopulator {
    private final int[] propertyKeyIds;
    private final UniqueIndexSampler sampler;

    public UniqueLuceneIndexPopulator(SchemaIndex index, NewIndexDescriptor descriptor) {
        super(index);
        this.propertyKeyIds = descriptor.schema().getPropertyIds();
        this.sampler = new UniqueIndexSampler();
    }

    public void verifyDeferredConstraints(PropertyAccessor accessor) throws IndexEntryConflictException, IOException {
        this.luceneIndex.verifyUniqueness(accessor, this.propertyKeyIds);
    }

    public IndexUpdater newPopulatingUpdater(PropertyAccessor accessor) throws IOException {
        return new UniqueLuceneIndexPopulatingUpdater(this.writer, this.propertyKeyIds, this.luceneIndex, accessor, this.sampler);
    }

    public void includeSample(IndexEntryUpdate update) {
        this.sampler.increment(1L);
    }

    public void configureSampling(boolean onlineSampling) {
    }

    public IndexSample sampleResult() {
        return this.sampler.result();
    }
}

