/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.populator;

import java.io.IOException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndex;
import org.neo4j.kernel.api.impl.schema.populator.LuceneIndexPopulator;
import org.neo4j.kernel.api.impl.schema.populator.NonUniqueLuceneIndexPopulatingUpdater;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.NonUniqueIndexSampler;
import org.neo4j.storageengine.api.schema.IndexSample;

public class NonUniqueLuceneIndexPopulator
extends LuceneIndexPopulator {
    private final NonUniqueIndexSampler sampler;

    public NonUniqueLuceneIndexPopulator(LuceneSchemaIndex luceneIndex, IndexSamplingConfig samplingConfig) {
        super(luceneIndex);
        this.sampler = new NonUniqueIndexSampler(samplingConfig.sampleSizeLimit());
    }

    public void verifyDeferredConstraints(PropertyAccessor accessor) throws IndexEntryConflictException, IOException {
    }

    public IndexUpdater newPopulatingUpdater(PropertyAccessor propertyAccessor) throws IOException {
        return new NonUniqueLuceneIndexPopulatingUpdater(this.writer, this.sampler);
    }

    public void includeSample(NodePropertyUpdate update) {
        this.sampler.include(LuceneDocumentStructure.encodedStringValue(update.getValueAfter()));
    }

    public IndexSample sampleResult() {
        return this.sampler.result();
    }
}

