/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.index.impl.lucene.legacy.EntityId;
import org.neo4j.index.impl.lucene.legacy.IndexType;
import org.neo4j.index.impl.lucene.legacy.LuceneDataSource;
import org.neo4j.index.impl.lucene.legacy.LuceneLegacyIndex;
import org.neo4j.index.impl.lucene.legacy.LuceneUtil;
import org.neo4j.index.impl.lucene.legacy.TxData;
import org.neo4j.index.impl.lucene.legacy.TxDataHolder;
import org.neo4j.index.lucene.QueryContext;
import org.neo4j.kernel.api.impl.index.collector.DocValuesCollector;

class FullTxData
extends TxData {
    private static final String ORPHANS_KEY = "__all__";
    public static final String TX_STATE_KEY = "__tx_state__";
    private static final byte[] TX_STATE_VALUE = new byte[]{1};
    private static final String ORPHANS_VALUE = "1";
    private Directory directory;
    private IndexWriter writer;
    private boolean modified;
    private IndexReader reader;
    private IndexSearcher searcher;
    private final Map<Long, Document> cachedDocuments = new HashMap<Long, Document>();
    private Set<String> orphans;

    FullTxData(LuceneLegacyIndex index) {
        super(index);
    }

    @Override
    void add(TxDataHolder holder, EntityId entityId, String key, Object value) {
        try {
            this.ensureLuceneDataInstantiated();
            long id = entityId.id();
            Document document = this.findDocument(id);
            boolean add = false;
            if (document == null) {
                document = IndexType.newDocument(entityId);
                document.add((IndexableField)new StoredField(TX_STATE_KEY, TX_STATE_VALUE));
                this.cachedDocuments.put(id, document);
                add = true;
            }
            if (key == null && value == null) {
                document.add((IndexableField)new StringField(ORPHANS_KEY, ORPHANS_VALUE, Field.Store.NO));
                this.addOrphan(null);
            } else if (value == null) {
                document.add((IndexableField)new StringField(ORPHANS_KEY, key, Field.Store.NO));
                this.addOrphan(key);
            } else {
                this.index.type.addToDocument(document, key, value);
            }
            if (add) {
                this.writer.addDocument((Iterable)document);
            } else {
                this.writer.updateDocument(this.index.type.idTerm(id), (Iterable)document);
            }
            this.invalidateSearcher();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addOrphan(String key) {
        if (this.orphans == null) {
            this.orphans = new HashSet<String>();
        }
        this.orphans.add(key);
    }

    private Document findDocument(long id) {
        return this.cachedDocuments.get(id);
    }

    private void ensureLuceneDataInstantiated() {
        if (this.directory == null) {
            try {
                this.directory = new RAMDirectory();
                IndexWriterConfig writerConfig = new IndexWriterConfig(this.index.type.analyzer);
                this.writer = new IndexWriter(this.directory, writerConfig);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    void remove(TxDataHolder holder, EntityId entityId, String key, Object value) {
        try {
            this.ensureLuceneDataInstantiated();
            long id = entityId.id();
            Document document = this.findDocument(id);
            if (document != null) {
                this.index.type.removeFromDocument(document, key, value);
                if (LuceneDataSource.documentIsEmpty(document)) {
                    this.writer.deleteDocuments(new Term[]{this.index.type.idTerm(id)});
                } else {
                    this.writer.updateDocument(this.index.type.idTerm(id), (Iterable)document);
                }
            }
            this.invalidateSearcher();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    Collection<EntityId> query(TxDataHolder holder, Query query, QueryContext contextOrNull) {
        return this.internalQuery(query, contextOrNull);
    }

    private Collection<EntityId> internalQuery(Query query, QueryContext contextOrNull) {
        if (this.directory == null) {
            return Collections.emptySet();
        }
        try {
            Sort sorting = contextOrNull != null ? contextOrNull.getSorting() : null;
            boolean prioritizeCorrectness = contextOrNull == null || !contextOrNull.getTradeCorrectnessForSpeed();
            IndexSearcher theSearcher = this.searcher(prioritizeCorrectness);
            query = this.includeOrphans(query);
            DocValuesCollector docValuesCollector = new DocValuesCollector(prioritizeCorrectness);
            theSearcher.search(query, (Collector)docValuesCollector);
            ArrayList<EntityId> result = new ArrayList<EntityId>();
            PrimitiveLongIterator valuesIterator = docValuesCollector.getSortedValuesIterator("_id_", sorting);
            while (valuesIterator.hasNext()) {
                result.add(new EntityId.IdData(valuesIterator.next()));
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Query includeOrphans(Query query) {
        if (this.orphans == null) {
            return query;
        }
        return new BooleanQuery.Builder().add(this.injectOrphans(query), BooleanClause.Occur.SHOULD).add((Query)new TermQuery(new Term(ORPHANS_KEY, ORPHANS_VALUE)), BooleanClause.Occur.SHOULD).build();
    }

    private Query injectOrphans(Query query) {
        if (query instanceof BooleanQuery) {
            BooleanQuery source = (BooleanQuery)query;
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (BooleanClause clause : source.clauses()) {
                builder.add(this.injectOrphans(clause.getQuery()), clause.getOccur());
            }
            return builder.build();
        }
        String orphanField = this.extractTermField(query);
        if (orphanField == null) {
            return query;
        }
        return new BooleanQuery.Builder().add(query, BooleanClause.Occur.SHOULD).add((Query)new TermQuery(new Term(ORPHANS_KEY, orphanField)), BooleanClause.Occur.SHOULD).build();
    }

    private String extractTermField(Query query) {
        if (query instanceof TermQuery) {
            return ((TermQuery)query).getTerm().field();
        }
        if (query instanceof WildcardQuery) {
            return ((WildcardQuery)query).getTerm().field();
        }
        if (query instanceof PrefixQuery) {
            return ((PrefixQuery)query).getPrefix().field();
        }
        if (query instanceof MatchAllDocsQuery) {
            return null;
        }
        String field = this.getFieldFromExtractTerms(query);
        if (field != null) {
            return field;
        }
        return this.getFieldViaReflection(query);
    }

    private String getFieldViaReflection(Query query) {
        try {
            try {
                Term term = (Term)query.getClass().getMethod("getTerm", new Class[0]).invoke((Object)query, new Object[0]);
                return term.field();
            }
            catch (NoSuchMethodException e) {
                return (String)query.getClass().getMethod("getField", new Class[0]).invoke((Object)query, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getFieldFromExtractTerms(Query query) {
        HashSet terms = new HashSet();
        try {
            this.searcher.createNormalizedWeight(query, false).extractTerms(terms);
        }
        catch (IOException ioe) {
            throw new UnsupportedOperationException(ioe);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return terms.isEmpty() ? null : ((Term)terms.iterator().next()).field();
    }

    @Override
    void close() {
        LuceneUtil.close(this.writer);
        LuceneUtil.close(this.reader);
        LuceneUtil.close(this.searcher);
    }

    private void invalidateSearcher() {
        this.modified = true;
    }

    private IndexSearcher searcher(boolean allowRefreshSearcher) {
        if (!(this.searcher == null || this.modified && allowRefreshSearcher)) {
            return this.searcher;
        }
        try {
            DirectoryReader newReader;
            DirectoryReader directoryReader = newReader = this.reader == null ? DirectoryReader.open((IndexWriter)this.writer) : DirectoryReader.openIfChanged((DirectoryReader)((DirectoryReader)this.reader));
            if (newReader == null || newReader == this.reader) {
                IndexSearcher indexSearcher = this.searcher;
                return indexSearcher;
            }
            LuceneUtil.close(this.reader);
            this.reader = newReader;
            LuceneUtil.close(this.searcher);
            this.searcher = new IndexSearcher(this.reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (allowRefreshSearcher) {
                this.modified = false;
            }
        }
        return this.searcher;
    }

    @Override
    IndexSearcher asSearcher(TxDataHolder holder, QueryContext context) {
        boolean refresh = context == null || !context.getTradeCorrectnessForSpeed();
        return this.searcher(refresh);
    }

    @Override
    Collection<EntityId> get(TxDataHolder holder, String key, Object value) {
        return this.internalQuery(this.index.type.get(key, value), null);
    }

    @Override
    Collection<EntityId> getOrphans(String key) {
        return Collections.emptyList();
    }
}

