/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.labelscan.storestrategy;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.neo4j.kernel.api.impl.labelscan.bitmaps.Bitmap;
import org.neo4j.kernel.api.impl.labelscan.bitmaps.BitmapFormat;

public enum BitmapDocumentFormat {
    _32(BitmapFormat._32){

        @Override
        protected Field createLabelField(String label, long bitmap) {
            assert ((bitmap & 0xFFFFFFFF00000000L) == 0L) : "Tried to store a bitmap as int, but which had values outside int limits";
            return new NumericDocValuesField(label, bitmap);
        }

        @Override
        protected void addLabelFields(Document document, String label, long bitmap) {
            assert ((bitmap & 0xFFFFFFFF00000000L) == 0L) : "Tried to store a bitmap as int, but which had values outside int limits";
            document.add((IndexableField)new NumericDocValuesField(label, bitmap));
            document.add((IndexableField)new IntField(label, (int)bitmap, Field.Store.YES));
        }
    }
    ,
    _64(BitmapFormat._64){

        @Override
        protected Field createLabelField(String label, long bitmap) {
            return new NumericDocValuesField(label, bitmap);
        }

        @Override
        protected void addLabelFields(Document document, String label, long bitmap) {
            document.add((IndexableField)new NumericDocValuesField(label, bitmap));
            document.add((IndexableField)new LongField(label, bitmap, Field.Store.YES));
        }
    };

    public static final String RANGE = "range";
    public static final String LABEL = "label";
    private final BitmapFormat format;

    private BitmapDocumentFormat(BitmapFormat format) {
        this.format = format;
    }

    public String toString() {
        return String.format("%s{%s bit}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.format});
    }

    public BitmapFormat bitmapFormat() {
        return this.format;
    }

    public long rangeOf(Document doc) {
        return Long.parseLong(doc.get(RANGE));
    }

    public long rangeOf(IndexableField field) {
        return Long.parseLong(field.stringValue());
    }

    public long mapOf(Document doc, long labelId) {
        return this.bitmap(doc.getField(this.label(labelId)));
    }

    public Query labelQuery(long labelId) {
        return new TermQuery(new Term(LABEL, Long.toString(labelId)));
    }

    public Query rangeQuery(long range) {
        return new TermQuery(new Term(RANGE, Long.toString(range)));
    }

    public IndexableField rangeField(long range) {
        return new StringField(RANGE, Long.toString(range), Field.Store.YES);
    }

    public void addRangeValuesField(Document doc, long range) {
        doc.add(this.rangeField(range));
        doc.add((IndexableField)new NumericDocValuesField(RANGE, range));
    }

    public IndexableField labelField(long key, long bitmap) {
        return this.createLabelField(this.label(key), bitmap);
    }

    protected abstract Field createLabelField(String var1, long var2);

    protected abstract void addLabelFields(Document var1, String var2, long var3);

    public void addLabelAndSearchFields(Document document, long label, Bitmap bitmap) {
        this.addLabelFields(document, this.label(label), bitmap.bitmap());
        document.add(this.labelSearchField(label));
    }

    public IndexableField labelSearchField(long label) {
        return new StringField(LABEL, Long.toString(label), Field.Store.YES);
    }

    public IndexableField labelField(long key, Bitmap value) {
        return this.labelField(key, value.bitmap());
    }

    String label(long key) {
        return Long.toString(key);
    }

    public long labelId(IndexableField field) {
        return Long.parseLong(field.name());
    }

    public Term rangeTerm(long range) {
        return new Term(RANGE, Long.toString(range));
    }

    public Term rangeTerm(Document document) {
        return new Term(RANGE, document.get(RANGE));
    }

    public boolean isRangeOrLabelField(IndexableField field) {
        String fieldName = field.name();
        return RANGE.equals(fieldName) || LABEL.equals(fieldName);
    }

    public boolean isRangeField(IndexableField field) {
        return RANGE.equals(field.name());
    }

    public boolean isLabelBitmapField(IndexableField field) {
        return !this.isRangeOrLabelField(field);
    }

    public Bitmap readBitmap(IndexableField field) {
        return new Bitmap(this.bitmap(field));
    }

    private long bitmap(IndexableField field) {
        if (field == null) {
            return 0L;
        }
        Number numericValue = field.numericValue();
        if (numericValue == null) {
            throw new IllegalArgumentException(field + " is not a numeric field");
        }
        return numericValue.longValue();
    }
}

