/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.labelscan.LuceneLabelScanIndex;
import org.neo4j.kernel.api.impl.labelscan.LuceneLabelScanIndexBuilder;
import org.neo4j.kernel.api.impl.labelscan.LuceneLabelScanStore;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.logging.LogProvider;

public class LuceneLabelScanStoreBuilder {
    private final File storeDir;
    private final LabelScanStoreProvider.FullStoreChangeStream fullStoreStream;
    private final FileSystemAbstraction fileSystem;
    private final LogProvider logProvider;
    private LuceneLabelScanStore labelScanStore;

    public LuceneLabelScanStoreBuilder(File storeDir, LabelScanStoreProvider.FullStoreChangeStream fullStoreStream, FileSystemAbstraction fileSystem, LogProvider logProvider) {
        this.storeDir = storeDir;
        this.fullStoreStream = fullStoreStream;
        this.fileSystem = fileSystem;
        this.logProvider = logProvider;
    }

    public LabelScanStore build() {
        if (null == this.labelScanStore) {
            LuceneLabelScanIndex index = ((LuceneLabelScanIndexBuilder)((LuceneLabelScanIndexBuilder)LuceneLabelScanIndexBuilder.create().withFileSystem(this.fileSystem)).withIndexRootFolder(LabelScanStoreProvider.getStoreDirectory((File)this.storeDir))).build();
            this.labelScanStore = new LuceneLabelScanStore(index, this.fullStoreStream, this.logProvider, LuceneLabelScanStore.Monitor.EMPTY);
            try {
                this.labelScanStore.init();
                this.labelScanStore.start();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.labelScanStore;
    }
}

