/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.writer;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.api.impl.index.WritableDatabaseIndex;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectory;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexWriter;
import org.neo4j.kernel.api.impl.index.lucene.LuceneSettings;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.schema.writer.LucenePartitionIndexWriter;

public class PartitionedIndexWriter
implements LucenePartitionIndexWriter {
    private static final Integer DEFAULT_MAXIMUM_PARTITION_SIZE = 1932735168;
    private final WritableDatabaseIndex<?, ?> index;
    private final int maximumPartitionSize;

    public PartitionedIndexWriter(WritableDatabaseIndex<?, ?> index, Config config) {
        this.index = index;
        Integer configuredMaxPartitionSize = (Integer)config.get(LuceneSettings.lucene_max_partition_size);
        this.maximumPartitionSize = Objects.requireNonNullElse(configuredMaxPartitionSize, DEFAULT_MAXIMUM_PARTITION_SIZE);
    }

    @Override
    public void addDocument(LuceneDocument doc) throws IOException {
        this.getIndexWriter(1).addDocument(doc);
    }

    @Override
    public void addDocuments(int numDocs, Iterable<LuceneDocument> documents) throws IOException {
        this.getIndexWriter(numDocs).addDocuments(documents);
    }

    @Override
    public void updateDocument(String idField, long id, LuceneDocument doc) throws IOException {
        List partitions = this.index.getPartitions();
        if (WritableDatabaseIndex.hasSinglePartition(partitions) && this.writablePartition(WritableDatabaseIndex.getFirstPartition(partitions), 1)) {
            WritableDatabaseIndex.getFirstPartition(partitions).getIndexWriter().updateDocument(idField, id, doc);
        } else {
            this.deleteDocuments(idField, id);
            this.addDocument(doc);
        }
    }

    @Override
    public void addDirectory(int count, LuceneDirectory directory) throws IOException {
        this.getIndexWriter(count).addIndexes(directory);
    }

    @Override
    public void deleteDocuments(String idField, long id) throws IOException {
        List partitions = this.index.getPartitions();
        for (AbstractIndexPartition partition : partitions) {
            partition.getIndexWriter().deleteDocuments(idField, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LuceneIndexWriter getIndexWriter(int numDocs) throws IOException {
        WritableDatabaseIndex<?, ?> writableDatabaseIndex = this.index;
        synchronized (writableDatabaseIndex) {
            return this.unsafeGetIndexWriter(numDocs);
        }
    }

    private LuceneIndexWriter unsafeGetIndexWriter(int numDocs) throws IOException {
        List indexPartitions = this.index.getPartitions();
        int size = indexPartitions.size();
        for (int i = 0; i < size; ++i) {
            AbstractIndexPartition partition = (AbstractIndexPartition)indexPartitions.get(i);
            if (!this.writablePartition(partition, numDocs)) continue;
            return partition.getIndexWriter();
        }
        AbstractIndexPartition indexPartition = this.index.addNewPartition();
        return indexPartition.getIndexWriter();
    }

    private boolean writablePartition(AbstractIndexPartition partition, int numDocs) {
        return this.maximumPartitionSize - partition.getIndexWriter().getMaxDocs() >= numDocs;
    }
}

