/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import java.io.Serializable;
import java.util.Comparator;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.factory.SortedSets;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.SetIterable;
import org.eclipse.collections.api.set.sorted.ImmutableSortedSet;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.internal.schema.IndexConfigValidationRecords;
import org.neo4j.internal.schema.IndexConfigValidationWrapper;
import org.neo4j.internal.schema.SettingsAccessor;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.impl.schema.vector.IndexSettingValidators;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexConfig;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexConfigUtils;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexVersion;
import org.neo4j.values.storable.Value;

public interface VectorIndexSettingsValidator {
    public IndexConfigValidationRecords validate(SettingsAccessor var1);

    default public VectorIndexConfig validateToVectorIndexConfig(SettingsAccessor settings) {
        return this.validateToVectorIndexConfig(settings, this.validate(settings));
    }

    public VectorIndexConfig validateToVectorIndexConfig(SettingsAccessor var1, IndexConfigValidationRecords var2);

    public VectorIndexConfig trustIsValidToVectorIndexConfig(SettingsAccessor var1);

    public VectorIndexConfig trustIsValidToVectorIndexConfig(IndexConfigValidationRecords var1);

    public ImmutableSortedSet<IndexSetting> validSettings();

    public static class ValidatorNotFoundForKernelVersion
    extends ValidatorNotFound {
        ValidatorNotFoundForKernelVersion(VectorIndexVersion version, KernelVersion kernelVersion) {
            super(new IllegalStateException("%s not found for '%s' on '%s'.".formatted(VectorIndexSettingsValidator.class.getSimpleName(), version.descriptor().name(), kernelVersion)));
        }
    }

    public static class ValidatorNotFound
    implements VectorIndexSettingsValidator {
        private final IllegalStateException exception;

        ValidatorNotFound(IllegalStateException exception) {
            this.exception = exception;
        }

        @Override
        public IndexConfigValidationRecords validate(SettingsAccessor settings) {
            throw this.exception;
        }

        @Override
        public VectorIndexConfig validateToVectorIndexConfig(SettingsAccessor settings) {
            throw this.exception;
        }

        @Override
        public VectorIndexConfig validateToVectorIndexConfig(SettingsAccessor settings, IndexConfigValidationRecords validationRecords) {
            throw this.exception;
        }

        @Override
        public VectorIndexConfig trustIsValidToVectorIndexConfig(SettingsAccessor settings) {
            throw this.exception;
        }

        @Override
        public VectorIndexConfig trustIsValidToVectorIndexConfig(IndexConfigValidationRecords validationRecords) {
            throw this.exception;
        }

        @Override
        public ImmutableSortedSet<IndexSetting> validSettings() {
            return SortedSets.immutable.empty();
        }
    }

    public static class Validators
    implements VectorIndexSettingsValidator {
        private final VectorIndexVersion version;
        private final ImmutableSortedSet<IndexSettingValidators.IndexSettingValidator<? extends Value, ?>> validators;
        private final ImmutableSortedSet<IndexSetting> validSettings;
        private final ImmutableSortedSet<String> validSettingNames;
        private final ImmutableSortedSet<String> handledSettingNames;

        @SafeVarargs
        Validators(VectorIndexVersion version, IndexSettingValidators.IndexSettingValidator<? extends Value, ?> ... validators) {
            this.version = version;
            MutableSet seenSettingNames = Sets.mutable.withInitialCapacity(validators.length);
            MutableList checkedValidators = Lists.mutable.withInitialCapacity(validators.length);
            for (IndexSettingValidators.IndexSettingValidator<Value, ?> indexSettingValidator : validators) {
                if (!seenSettingNames.add((Object)indexSettingValidator.setting().getSettingName())) {
                    throw new IllegalStateException("Expected a single %s to be provided for '%s', multiple given.".formatted(IndexSettingValidators.IndexSettingValidator.class.getSimpleName(), indexSettingValidator.setting().getSettingName()));
                }
                checkedValidators.add(indexSettingValidator);
            }
            this.validators = checkedValidators.toImmutableSortedSet(Comparator.comparing(validator -> validator.setting().getSettingName(), String.CASE_INSENSITIVE_ORDER));
            MutableSet handledSettings = this.validators.collect(IndexSettingValidators.IndexSettingValidator::setting).toSet();
            this.handledSettingNames = handledSettings.collect(IndexSetting::getSettingName).toImmutableSortedSet(String.CASE_INSENSITIVE_ORDER);
            this.validSettings = handledSettings.difference((SetIterable)this.validators.asLazy().selectInstancesOf(IndexSettingValidators.ReadDefaultOnly.class).collect(IndexSettingValidators.IndexSettingValidator::setting).toSet()).toImmutableSortedSet(VectorIndexConfigUtils.INDEX_SETTING_COMPARATOR);
            this.validSettingNames = this.validSettings.collect(IndexSetting::getSettingName).toImmutableSortedSet(String.CASE_INSENSITIVE_ORDER);
        }

        @Override
        public IndexConfigValidationRecords validate(SettingsAccessor settings) {
            IndexConfigValidationRecords validationRecords = IndexConfigValidationWrapper.validateSettingNames((SetIterable)settings.settingNames(), this.handledSettingNames);
            this.validators.asLazy().collect((Function & Serializable)validator -> validator.validate(settings)).forEach(arg_0 -> ((IndexConfigValidationRecords)validationRecords).with(arg_0));
            return validationRecords;
        }

        @Override
        public VectorIndexConfig validateToVectorIndexConfig(SettingsAccessor settings, IndexConfigValidationRecords validationRecords) {
            VectorIndexConfigUtils.assertValidRecords(validationRecords, this.version.descriptor(), this.validSettingNames);
            ImmutableSortedSet validRecords = validationRecords.validRecords();
            return new VectorIndexConfig(this.version, VectorIndexConfigUtils.toIndexConfig((RichIterable<IndexConfigValidationRecords.Valid>)validRecords, this.validSettingNames), VectorIndexConfigUtils.toValidSettings((RichIterable<IndexConfigValidationRecords.Valid>)validRecords), this.validSettingNames, this.handledSettingNames);
        }

        @Override
        public VectorIndexConfig trustIsValidToVectorIndexConfig(SettingsAccessor settings) {
            ImmutableList validRecords = this.validators.collect((Function & Serializable)validator -> validator.trustIsValid(settings));
            return new VectorIndexConfig(this.version, VectorIndexConfigUtils.toIndexConfig((RichIterable<IndexConfigValidationRecords.Valid>)validRecords), VectorIndexConfigUtils.toValidSettings((RichIterable<IndexConfigValidationRecords.Valid>)validRecords), this.validSettingNames, this.handledSettingNames);
        }

        @Override
        public VectorIndexConfig trustIsValidToVectorIndexConfig(IndexConfigValidationRecords validationRecords) {
            ImmutableSortedSet validRecords = validationRecords.validRecords();
            return new VectorIndexConfig(this.version, VectorIndexConfigUtils.toIndexConfig((RichIterable<IndexConfigValidationRecords.Valid>)validRecords), VectorIndexConfigUtils.toValidSettings((RichIterable<IndexConfigValidationRecords.Valid>)validRecords), this.validSettingNames, this.handledSettingNames);
        }

        @Override
        public ImmutableSortedSet<IndexSetting> validSettings() {
            return this.validSettings;
        }
    }
}

