/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocumentsFactory;
import org.neo4j.kernel.api.impl.schema.vector.VectorDocumentStructure;
import org.neo4j.kernel.api.impl.schema.vector.VectorSimilarityFunctions;
import org.neo4j.kernel.api.impl.schema.writer.LucenePartitionIndexWriter;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.AnyValue;
import org.neo4j.values.VectorCandidate;
import org.neo4j.values.storable.Value;

class VectorIndexPopulatingUpdater
implements IndexUpdater {
    private final LucenePartitionIndexWriter writer;
    private final IndexUpdateIgnoreStrategy ignoreStrategy;
    private final VectorDocumentStructure documentStructure;
    private final VectorSimilarityFunctions.LuceneVectorSimilarityFunction similarityFunction;

    VectorIndexPopulatingUpdater(LucenePartitionIndexWriter writer, IndexUpdateIgnoreStrategy ignoreStrategy, VectorDocumentStructure documentStructure, VectorSimilarityFunctions.LuceneVectorSimilarityFunction similarityFunction) {
        this.writer = writer;
        this.documentStructure = documentStructure;
        this.ignoreStrategy = ignoreStrategy;
        this.similarityFunction = similarityFunction;
    }

    public void process(IndexEntryUpdate update) {
        ValueIndexEntryUpdate valueUpdate = this.asValueUpdate(update);
        if (valueUpdate == null) {
            return;
        }
        try {
            long entityId = valueUpdate.getEntityId();
            Value[] values = valueUpdate.values();
            VectorCandidate candidate = VectorCandidate.maybeFrom((AnyValue)values[0]);
            UpdateMode updateMode = valueUpdate.updateMode();
            switch (updateMode) {
                case ADDED: {
                    this.writer.updateDocument("id", entityId, LuceneDocumentsFactory.CURRENT.createVectorDocument(this.documentStructure, entityId, candidate, this.similarityFunction));
                    break;
                }
                case CHANGED: {
                    this.writer.updateOrDeleteDocument("id", entityId, LuceneDocumentsFactory.CURRENT.createVectorDocument(this.documentStructure, entityId, candidate, this.similarityFunction));
                    break;
                }
                case REMOVED: {
                    this.writer.deleteDocuments("id", entityId);
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ValueIndexEntryUpdate asValueUpdate(IndexEntryUpdate update) {
        ValueIndexEntryUpdate valueUpdate = super.asValueUpdate(update);
        return !this.ignoreStrategy.ignore(valueUpdate) ? this.ignoreStrategy.toEquivalentUpdate(valueUpdate) : null;
    }

    public void close() throws IndexEntryConflictException {
    }
}

