/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexSearcher;
import org.neo4j.kernel.api.impl.index.lucene.LuceneQueryContext;
import org.neo4j.kernel.api.impl.schema.AbstractLuceneIndexReader;
import org.neo4j.kernel.api.impl.schema.LuceneQueryFactory;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.logging.LogProvider;

public abstract class AbstractTextIndexReader
extends AbstractLuceneIndexReader {
    private final SearcherReference searcherReference;

    protected AbstractTextIndexReader(IndexDescriptor descriptor, SearcherReference searcherReference, IndexUsageTracking usageTracker, LuceneQueryFactory queryFactory, LogProvider logProvider) {
        super(descriptor, usageTracker, queryFactory, logProvider);
        this.searcherReference = searcherReference;
    }

    @Override
    protected IndexProgressor indexProgressor(LuceneQueryFactory queryFactory, PropertyIndexQuery predicate, IndexQueryConstraints constraints, IndexProgressor.EntityValueClient client) {
        LuceneIndexSearcher searcher = this.getIndexSearcher();
        LuceneQueryContext queryContext = queryFactory.createQuery(searcher, predicate, constraints, this.descriptor);
        try {
            return searcher.searchDocValues(queryContext, this.entityIdFieldKey(), client);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() {
        try (SearcherReference searcherReference = this.searcherReference;){
            super.close();
        }
        catch (IOException e) {
            throw new IndexReaderCloseException(e);
        }
    }

    protected LuceneIndexSearcher getIndexSearcher() {
        return this.searcherReference.getIndexSearcher();
    }
}

