/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v9;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocumentsFactory;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9Document;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9ReusableDocWithId;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramTokenStream;
import org.neo4j.kernel.api.impl.schema.vector.VectorDocumentStructure;
import org.neo4j.kernel.api.impl.schema.vector.VectorSimilarityFunctions;
import org.neo4j.values.VectorCandidate;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class Lucene9DocumentsFactory
implements LuceneDocumentsFactory {
    public static final LuceneDocumentsFactory INSTANCE = new Lucene9DocumentsFactory();

    @Override
    public LuceneDocument newDocument() {
        return new Lucene9Document();
    }

    @Override
    public LuceneDocument reusableTextDocument(long id, Value ... values) {
        return Lucene9ReusableDocWithId.reusableTextDocument(id, values);
    }

    @Override
    public LuceneDocument reusableFulltextDocument(long id, String[] propertyNames, Value[] values) {
        return Lucene9ReusableDocWithId.reusableFulltextDocument(id, propertyNames, values);
    }

    @Override
    public LuceneDocument createTrigramDocument(long id, Value value) {
        Lucene9Document document = new Lucene9Document();
        document.addStringField("id", Long.toString(id), false);
        document.addNumericField("id", id);
        if (value.valueGroup() == ValueGroup.TEXT) {
            TrigramTokenStream tokenStream = new TrigramTokenStream(value.asObject().toString());
            TrigramField valueField = new TrigramField("0", tokenStream);
            document.document.add((IndexableField)valueField);
        }
        return document;
    }

    @Override
    public LuceneDocument createVectorDocument(VectorDocumentStructure vectorDocumentStructure, long id, VectorCandidate candidate, VectorSimilarityFunctions.LuceneVectorSimilarityFunction similarityFunction) {
        float[] vector = similarityFunction.maybeToValidVector(candidate);
        if (vector == null) {
            return null;
        }
        Lucene9Document document = new Lucene9Document();
        document.addStringField("id", Long.toString(id), false);
        document.addNumericField("id", id);
        document.addKnnFloatVectorField(vectorDocumentStructure.vectorValueKeyFor(vector.length), vector, similarityFunction);
        return document;
    }

    private static class TrigramField
    extends Field {
        private static final FieldType TYPE = new FieldType();

        private TrigramField(String name, TokenStream tokenStream) {
            super(name, tokenStream, (IndexableFieldType)TYPE);
        }

        static {
            TYPE.setOmitNorms(true);
            TYPE.setIndexOptions(IndexOptions.DOCS);
            TYPE.setTokenized(true);
            TYPE.setStored(false);
            TYPE.freeze();
        }
    }
}

