/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v9;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.KnnFloatVectorField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.schema.vector.VectorSimilarityFunctions;

class Lucene9Document
implements LuceneDocument {
    final Document document;

    Lucene9Document() {
        this(new Document());
    }

    Lucene9Document(Document document) {
        this.document = document;
    }

    @Override
    public void addNumericField(String key, long value) {
        this.document.add((IndexableField)new NumericDocValuesField(key, value));
    }

    @Override
    public void addStringField(String key, String string, boolean store) {
        this.document.add((IndexableField)new StringField(key, string, store ? Field.Store.YES : Field.Store.NO));
    }

    @Override
    public void addTextField(String key, String textValue, boolean store) {
        this.document.add((IndexableField)new TextField(key, textValue, store ? Field.Store.YES : Field.Store.NO));
    }

    @Override
    public void addKnnFloatVectorField(String key, float[] vector, VectorSimilarityFunctions.LuceneVectorSimilarityFunction similarityFunction) {
        this.document.add((IndexableField)new KnnFloatVectorField(key, vector, similarityFunction.toLucene()));
    }

    @Override
    public String get(String key) {
        return this.document.get(key);
    }
}

