/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.backup;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;

public class ReadOnlyIndexSnapshotFileIterator
extends PrefetchingIterator<Path>
implements ResourceIterator<Path> {
    private final Path indexDirectory;
    private final Iterator<String> fileNames;

    protected ReadOnlyIndexSnapshotFileIterator(Path indexDirectory, Collection<String> fileNames) {
        this.indexDirectory = indexDirectory;
        this.fileNames = fileNames.iterator();
    }

    protected Path fetchNextOrNull() {
        if (!this.fileNames.hasNext()) {
            return null;
        }
        return this.indexDirectory.resolve(this.fileNames.next());
    }

    public void close() {
    }

    protected Path getIndexDirectory() {
        return this.indexDirectory;
    }
}

