/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.lucene.LuceneAllDocumentsReader;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;

public class LucenePartitionsAllDocumentsReader
implements BoundedIterable<LuceneDocument> {
    private final List<LuceneAllDocumentsReader> partitionReaders;
    private final List<SearcherReference> searchers;

    public LucenePartitionsAllDocumentsReader(List<LuceneAllDocumentsReader> partitionReaders, List<SearcherReference> searchers) {
        this.partitionReaders = partitionReaders;
        this.searchers = searchers;
    }

    public long maxCount() {
        return this.partitionReaders.stream().mapToLong(BoundedIterable::maxCount).sum();
    }

    public Iterator<LuceneDocument> iterator() {
        Iterator<Iterator> iterators = this.partitionReaders.stream().map(Iterable::iterator).toList().iterator();
        return Iterators.concat(iterators);
    }

    public List<Iterator<LuceneDocument>> partition(int numPartitions) {
        int partitionsPerIndexPartition = Integer.max(1, numPartitions / this.partitionReaders.size());
        ArrayList<Iterator<LuceneDocument>> result = new ArrayList<Iterator<LuceneDocument>>();
        for (LuceneAllDocumentsReader partitionReader : this.partitionReaders) {
            int indexPartitionMaxCount = Math.toIntExact(partitionReader.maxCount());
            int roughCountPerIndexPartition = indexPartitionMaxCount / partitionsPerIndexPartition;
            for (int i = 0; i < partitionsPerIndexPartition; ++i) {
                int from = i * roughCountPerIndexPartition;
                int to = i == partitionsPerIndexPartition - 1 ? indexPartitionMaxCount : from + roughCountPerIndexPartition;
                result.add(partitionReader.iterator(from, to));
            }
        }
        return result;
    }

    public void close() throws IOException {
        IOUtils.closeAll(this.partitionReaders);
        IOUtils.closeAll(this.searchers);
    }
}

