/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.vector;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Locale;
import java.util.OptionalInt;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.factory.SortedMaps;
import org.eclipse.collections.api.factory.primitive.BooleanSets;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.sorted.ImmutableSortedMap;
import org.eclipse.collections.api.set.SetIterable;
import org.eclipse.collections.api.set.primitive.BooleanSet;
import org.eclipse.collections.api.set.primitive.ImmutableBooleanSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.tuple.Tuples;
import org.neo4j.configuration.Config;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.internal.schema.AllIndexProviderDescriptors;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.impl.schema.vector.IndexSettingValidators;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexConfigUtils;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexSettingsValidator;
import org.neo4j.kernel.api.impl.schema.vector.VectorSimilarityFunctions;
import org.neo4j.kernel.api.vector.VectorSimilarityFunction;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.FloatingPointArray;
import org.neo4j.values.storable.NumberArray;
import org.neo4j.values.storable.Value;

public enum VectorIndexVersion {
    UNKNOWN(AllIndexProviderDescriptors.UNDECIDED, KernelVersion.EARLIEST, 0, 0, 0, (SetIterable)Sets.immutable.empty(), (BooleanSet)BooleanSets.immutable.empty()){

        @Override
        protected RichIterable<Pair<KernelVersion, VectorIndexSettingsValidator>> configureValidators() {
            return Lists.mutable.of((Object[])new Pair[]{Tuples.pair((Object)KernelVersion.EARLIEST, (Object)new VectorIndexSettingsValidator.ValidatorNotFound(new IllegalStateException("%s not found for '%s'".formatted(VectorIndexSettingsValidator.class.getSimpleName(), this.descriptor().name()))))});
        }

        @Override
        public boolean acceptsValueInstanceType(Value candidate) {
            return false;
        }
    }
    ,
    V1_0(AllIndexProviderDescriptors.VECTOR_V1_DESCRIPTOR, KernelVersion.VERSION_NODE_VECTOR_INDEX_INTRODUCED, 2048, 512, 3200, (SetIterable)Sets.mutable.of((Object[])new VectorSimilarityFunction[]{VectorSimilarityFunctions.EUCLIDEAN, VectorSimilarityFunctions.SIMPLE_COSINE}), (BooleanSet)BooleanSets.immutable.empty()){

        @Override
        protected RichIterable<Pair<KernelVersion, VectorIndexSettingsValidator>> configureValidators() {
            return Lists.mutable.of((Object[])new Pair[]{Tuples.pair((Object)KernelVersion.VERSION_NODE_VECTOR_INDEX_INTRODUCED, (Object)new VectorIndexSettingsValidator.Validators(this, new IndexSettingValidators.OptionalIntSettingValidator(IndexSetting.vector_Dimensions(), new VectorIndexConfigUtils.Range<Integer>(1, Integer.MAX_VALUE)), new IndexSettingValidators.SimilarityFunctionValidator((MapIterable<String, VectorSimilarityFunction>)this.nameToSimilarityFunction()), new IndexSettingValidators.ReadDefaultOnly<Boolean>(IndexSetting.vector_Quantization_Enabled(), false), new IndexSettingValidators.ReadDefaultOnly<Integer>(IndexSetting.vector_Hnsw_M(), 16), new IndexSettingValidators.ReadDefaultOnly<Integer>(IndexSetting.vector_Hnsw_Ef_Construction(), 100))), Tuples.pair((Object)KernelVersion.V5_12, (Object)new VectorIndexSettingsValidator.Validators(this, new IndexSettingValidators.OptionalIntSettingValidator(IndexSetting.vector_Dimensions(), new VectorIndexConfigUtils.Range<Integer>(1, this.maxDimensions())), new IndexSettingValidators.SimilarityFunctionValidator((MapIterable<String, VectorSimilarityFunction>)this.nameToSimilarityFunction()), new IndexSettingValidators.ReadDefaultOnly<Boolean>(IndexSetting.vector_Quantization_Enabled(), false), new IndexSettingValidators.ReadDefaultOnly<Integer>(IndexSetting.vector_Hnsw_M(), 16), new IndexSettingValidators.ReadDefaultOnly<Integer>(IndexSetting.vector_Hnsw_Ef_Construction(), 100)))});
        }

        @Override
        public boolean acceptsValueInstanceType(Value candidate) {
            return candidate instanceof FloatingPointArray;
        }
    }
    ,
    V2_0(AllIndexProviderDescriptors.VECTOR_V2_DESCRIPTOR, KernelVersion.VERSION_VECTOR_2_INTRODUCED, 4096, 512, 3200, (SetIterable)Sets.mutable.of((Object[])new VectorSimilarityFunction[]{VectorSimilarityFunctions.EUCLIDEAN, VectorSimilarityFunctions.L2_NORM_COSINE}), (BooleanSet)BooleanSets.immutable.of(new boolean[]{false, true})){

        @Override
        protected RichIterable<Pair<KernelVersion, VectorIndexSettingsValidator>> configureValidators() {
            return Lists.mutable.of((Object[])new Pair[]{Tuples.pair((Object)KernelVersion.VERSION_VECTOR_2_INTRODUCED, (Object)new VectorIndexSettingsValidator.Validators(this, new IndexSettingValidators.OptionalIntSettingValidator(IndexSetting.vector_Dimensions(), new VectorIndexConfigUtils.Range<Integer>(1, this.maxDimensions())), new IndexSettingValidators.SimilarityFunctionValidator((MapIterable<String, VectorSimilarityFunction>)this.nameToSimilarityFunction()), new IndexSettingValidators.ReadDefaultOnly<Boolean>(IndexSetting.vector_Quantization_Enabled(), false), new IndexSettingValidators.ReadDefaultOnly<Integer>(IndexSetting.vector_Hnsw_M(), 16), new IndexSettingValidators.ReadDefaultOnly<Integer>(IndexSetting.vector_Hnsw_Ef_Construction(), 100))), Tuples.pair((Object)KernelVersion.VERSION_VECTOR_QUANTIZATION_AND_HYPER_PARAMS, (Object)new VectorIndexSettingsValidator.Validators(this, new IndexSettingValidators.OptionalIntSettingValidator(IndexSetting.vector_Dimensions(), new VectorIndexConfigUtils.Range<Integer>(1, this.maxDimensions()), OptionalInt.empty()), new IndexSettingValidators.SimilarityFunctionValidator((MapIterable<String, VectorSimilarityFunction>)this.nameToSimilarityFunction(), VectorSimilarityFunctions.L2_NORM_COSINE), new IndexSettingValidators.QuantizationEnabledValidator((BooleanSet)this.supportedQuantizationBooleans(), false, true), new IndexSettingValidators.IntegerValidator(IndexSetting.vector_Hnsw_M(), 16, new VectorIndexConfigUtils.Range<Integer>(1, this.maxHnswM())), new IndexSettingValidators.IntegerValidator(IndexSetting.vector_Hnsw_Ef_Construction(), 100, new VectorIndexConfigUtils.Range<Integer>(1, this.maxHnswEfConstruction()))))});
        }

        @Override
        public boolean acceptsValueInstanceType(Value candidate) {
            return candidate instanceof NumberArray;
        }
    };

    public static final ImmutableList<VectorIndexVersion> KNOWN_VERSIONS;
    private final KernelVersion minimumRequiredKernelVersion;
    private final IndexProviderDescriptor descriptor;
    private final int maxDimensions;
    private final ImmutableMap<String, VectorSimilarityFunction> similarityFunctions;
    private final ImmutableBooleanSet quantizationBooleans;
    private final int maxHnswM;
    private final int maxHnswEfConstruction;
    private final ImmutableSortedMap<KernelVersion, VectorIndexSettingsValidator> validators;
    private final VectorIndexSettingsValidator latestIndexSettingValidator;

    public static VectorIndexVersion latestSupportedVersion(KernelVersion kernelVersion) {
        for (VectorIndexVersion version : KNOWN_VERSIONS.asReversed()) {
            if (!kernelVersion.isAtLeast(version.minimumRequiredKernelVersion)) continue;
            return version;
        }
        return UNKNOWN;
    }

    public static VectorIndexVersion fromDescriptor(IndexProviderDescriptor descriptor) {
        for (VectorIndexVersion version : KNOWN_VERSIONS.asReversed()) {
            if (!version.descriptor.equals((Object)descriptor)) continue;
            return version;
        }
        return UNKNOWN;
    }

    private VectorIndexVersion(IndexProviderDescriptor providerDescriptor, KernelVersion minimumRequiredKernelVersion, int maxDimensions, int maxHnswM, int maxHnswEfConstruction, SetIterable<VectorSimilarityFunction> supportedSimilarityFunctions, BooleanSet supportedQuantizationEnableds) {
        this.minimumRequiredKernelVersion = minimumRequiredKernelVersion;
        this.descriptor = providerDescriptor;
        this.maxDimensions = maxDimensions;
        this.similarityFunctions = supportedSimilarityFunctions.toImmutableMap((Function & Serializable)similarityFunction -> similarityFunction.name().toUpperCase(Locale.ROOT), (Function & Serializable)similarityFunction -> similarityFunction);
        this.quantizationBooleans = supportedQuantizationEnableds.toImmutable();
        this.maxHnswM = maxHnswM;
        this.maxHnswEfConstruction = maxHnswEfConstruction;
        this.validators = SortedMaps.mutable.of(Comparator.reverseOrder()).withAllKeyValues(this.configureValidators()).toImmutable();
        this.latestIndexSettingValidator = this.indexSettingValidator(KernelVersion.getLatestVersion((Config)Config.defaults()));
    }

    public KernelVersion minimumRequiredKernelVersion() {
        return this.minimumRequiredKernelVersion;
    }

    public IndexProviderDescriptor descriptor() {
        return this.descriptor;
    }

    @VisibleForTesting
    public int maxDimensions() {
        return this.maxDimensions;
    }

    @VisibleForTesting
    public int maxHnswM() {
        return this.maxHnswM;
    }

    @VisibleForTesting
    public int maxHnswEfConstruction() {
        return this.maxHnswEfConstruction;
    }

    protected abstract RichIterable<Pair<KernelVersion, VectorIndexSettingsValidator>> configureValidators();

    public abstract boolean acceptsValueInstanceType(Value var1);

    public VectorSimilarityFunction maybeSimilarityFunction(String name) {
        return (VectorSimilarityFunction)this.similarityFunctions.get((Object)name.toUpperCase(Locale.ROOT));
    }

    public VectorSimilarityFunction similarityFunction(String name) {
        VectorSimilarityFunction similarityFunction = this.maybeSimilarityFunction(name);
        if (similarityFunction == null) {
            throw new IllegalArgumentException("'%s' is an unsupported vector similarity function for index with provider %s. ".formatted(name, this.descriptor.name()) + "Supported: " + String.valueOf(this.similarityFunctions.keysView()));
        }
        return similarityFunction;
    }

    @VisibleForTesting
    public RichIterable<VectorSimilarityFunction> supportedSimilarityFunctions() {
        return this.similarityFunctions.valuesView();
    }

    ImmutableMap<String, VectorSimilarityFunction> nameToSimilarityFunction() {
        return this.similarityFunctions;
    }

    @VisibleForTesting
    public ImmutableBooleanSet supportedQuantizationBooleans() {
        return this.quantizationBooleans;
    }

    public VectorIndexSettingsValidator indexSettingValidator() {
        return this.latestIndexSettingValidator;
    }

    public VectorIndexSettingsValidator indexSettingValidator(KernelVersion kernelVersion) {
        Pair validator = (Pair)this.validators.keyValuesView().detect((Predicate & Serializable)kernelVersionAndValidator -> kernelVersion.isAtLeast((KernelVersion)kernelVersionAndValidator.getOne()));
        if (validator == null) {
            return new VectorIndexSettingsValidator.ValidatorNotFoundForKernelVersion(this, kernelVersion);
        }
        return (VectorIndexSettingsValidator)validator.getTwo();
    }

    static {
        KNOWN_VERSIONS = Lists.mutable.with((Object[])VectorIndexVersion.values()).without((Object)UNKNOWN).toImmutableList();
    }
}

