/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.trigram;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TotalHitCountCollector;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.schema.AbstractTextIndexReader;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramIndexSampler;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramQueryFactory;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.logging.LogProvider;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;

public class TrigramIndexReader
extends AbstractTextIndexReader {
    TrigramIndexReader(SearcherReference searcherReference, IndexDescriptor descriptor, IndexUsageTracking usageTracker, LogProvider logProvider) {
        super(descriptor, searcherReference, usageTracker, logProvider);
    }

    public IndexSampler createSampler() {
        return new TrigramIndexSampler(this.getIndexSearcher());
    }

    @Override
    protected Query toLuceneQuery(PropertyIndexQuery predicate, IndexQueryConstraints constraints) {
        return switch (predicate.type()) {
            case IndexQuery.IndexQueryType.ALL_ENTRIES -> TrigramQueryFactory.allValues();
            case IndexQuery.IndexQueryType.EXACT -> {
                String value = ((PropertyIndexQuery.ExactPredicate)predicate).value().asObject().toString();
                yield TrigramQueryFactory.exact(value);
            }
            case IndexQuery.IndexQueryType.STRING_PREFIX -> {
                PropertyIndexQuery.StringPrefixPredicate spp = (PropertyIndexQuery.StringPrefixPredicate)predicate;
                yield TrigramQueryFactory.stringPrefix(spp.prefix().stringValue());
            }
            case IndexQuery.IndexQueryType.STRING_CONTAINS -> {
                PropertyIndexQuery.StringContainsPredicate scp = (PropertyIndexQuery.StringContainsPredicate)predicate;
                yield TrigramQueryFactory.stringContains(scp.contains().stringValue());
            }
            case IndexQuery.IndexQueryType.STRING_SUFFIX -> {
                PropertyIndexQuery.StringSuffixPredicate ssp = (PropertyIndexQuery.StringSuffixPredicate)predicate;
                yield TrigramQueryFactory.stringSuffix(ssp.suffix().stringValue());
            }
            default -> throw this.invalidQuery(IllegalArgumentException::new, predicate);
        };
    }

    @Override
    protected String entityIdFieldKey() {
        return "id";
    }

    @Override
    protected boolean needStoreFilter(PropertyIndexQuery predicate) {
        return TrigramQueryFactory.needStoreFilter(predicate);
    }

    public long countIndexedEntities(long entityId, CursorContext cursorContext, int[] propertyKeyIds, Value ... propertyValues) {
        Query entityIdQuery = TrigramQueryFactory.getById(entityId);
        BooleanQuery.Builder entityIdAndValueQuery = new BooleanQuery.Builder();
        entityIdAndValueQuery.add(entityIdQuery, BooleanClause.Occur.MUST);
        Preconditions.checkState((propertyKeyIds.length == 1 ? 1 : 0) != 0, (String)"Text index does not support composite indexing. Tried to query index with multiple property keys.");
        String value = propertyValues[0].asObject().toString();
        Query valueQuery = TrigramQueryFactory.exact(value);
        entityIdAndValueQuery.add(valueQuery, BooleanClause.Occur.MUST);
        try {
            TotalHitCountCollector collector = new TotalHitCountCollector();
            this.getIndexSearcher().search((Query)entityIdAndValueQuery.build(), (Collector)collector);
            return collector.getTotalHits();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    BoundedIterable<Long> newAllEntriesValueReader(long fromIdInclusive, long toIdExclusive) throws IOException {
        return this.newAllEntriesValueReaderForPartition("id", this.getIndexSearcher(), (Query)TrigramQueryFactory.allValues(), fromIdInclusive, toIdExclusive);
    }
}

