/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.trigram;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramDocumentStructure;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.IndexValueValidator;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;

class TrigramIndexPopulatingUpdater
implements IndexUpdater {
    private final LuceneIndexWriter writer;
    private final IndexUpdateIgnoreStrategy ignoreStrategy;
    private final IndexValueValidator validator;

    TrigramIndexPopulatingUpdater(LuceneIndexWriter writer, IndexUpdateIgnoreStrategy ignoreStrategy, IndexValueValidator validator) {
        this.writer = writer;
        this.ignoreStrategy = ignoreStrategy;
        this.validator = validator;
    }

    public void process(IndexEntryUpdate update) {
        ValueIndexEntryUpdate valueUpdate = this.asValueUpdate(update);
        if (valueUpdate == null) {
            return;
        }
        try {
            long entityId = valueUpdate.getEntityId();
            Value[] values = valueUpdate.values();
            Value value = values[0];
            this.validator.validate(entityId, new Value[]{value});
            UpdateMode updateMode = valueUpdate.updateMode();
            switch (updateMode) {
                case ADDED: {
                    this.writer.updateDocument(TrigramDocumentStructure.newTermForChangeOrRemove(entityId), TrigramDocumentStructure.createLuceneDocument(entityId, value));
                    break;
                }
                case CHANGED: {
                    this.writer.updateOrDeleteDocument(TrigramDocumentStructure.newTermForChangeOrRemove(entityId), TrigramDocumentStructure.createLuceneDocument(entityId, value));
                    break;
                }
                case REMOVED: {
                    this.writer.deleteDocuments(TrigramDocumentStructure.newTermForChangeOrRemove(entityId));
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ValueIndexEntryUpdate asValueUpdate(IndexEntryUpdate update) {
        ValueIndexEntryUpdate valueUpdate = super.asValueUpdate(update);
        return !this.ignoreStrategy.ignore(valueUpdate) ? this.ignoreStrategy.toEquivalentUpdate(valueUpdate) : null;
    }

    public void close() throws IndexEntryConflictException {
    }
}

