/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import org.neo4j.configuration.Description;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.SettingsDeclaration;
import org.neo4j.graphdb.config.Setting;

public class LuceneSettings
implements SettingsDeclaration {
    @Internal
    @Description(value="Determines the minimal number of documents required before the buffered in-memory documents are flushed as a new Segment. Large values generally give faster indexing.")
    public static final Setting<Integer> lucene_writer_max_buffered_docs = SettingImpl.newBuilder((String)"internal.dbms.index.lucene.writer_max_buffered_docs", (SettingValueParser)SettingValueParsers.INT, (Object)100000).build();
    @Internal
    @Description(value="Determines the minimal number of documents required before the buffered in-memory documents are flushed as a new Segment during population. Large values generally give faster indexing.")
    public static final Setting<Integer> lucene_population_max_buffered_docs = SettingImpl.newBuilder((String)"internal.dbms.index.lucene.population_max_buffered_docs", (SettingValueParser)SettingValueParsers.INT, (Object)-1).build();
    @Internal
    @Description(value="Determines how often segment indices are merged by addDocument(). With smaller values, less RAM is used while indexing, and searches are faster, but indexing speed is slower. With larger values, more RAM is used during indexing, and while searches is slower, indexing is faster.")
    public static final Setting<Integer> lucene_merge_factor = SettingImpl.newBuilder((String)"internal.dbms.index.lucene.merge_factor", (SettingValueParser)SettingValueParsers.INT, (Object)2).build();
    @Internal
    @Description(value="Determines how often segment indices are merged by addDocument(). With smaller values, less RAM is used while indexing, and searches are faster, but indexing speed is slower. With larger values, more RAM is used during indexing, and while searches is slower, indexing is faster. This is only used on vector indexes after they have been created.")
    public static final Setting<Integer> vector_standard_merge_factor = SettingImpl.newBuilder((String)"internal.dbms.index.vector.standard_merge_factor", (SettingValueParser)SettingValueParsers.INT, (Object)50).build();
    @Internal
    @Description(value="Determines how often segment indices are merged by addDocument(). With smaller values, less RAM is used while indexing, and searches are faster, but indexing speed is slower. With larger values, more RAM is used during indexing, and while searches is slower, indexing is faster. This is only used on vector indexes during initial creation.")
    public static final Setting<Integer> vector_population_merge_factor = SettingImpl.newBuilder((String)"internal.dbms.index.vector.population_merge_factor", (SettingValueParser)SettingValueParsers.INT, (Object)1000).build();
    @Internal
    @Description(value="If a merged segment will be more than this percentage of the total size of the index, leave the segment as non-compound file even if compound file is enabled. Set to 1.0 to always use CFS regardless of merge size.")
    public static final Setting<Double> lucene_nocfs_ratio = SettingImpl.newBuilder((String)"internal.dbms.index.lucene.nocfs.ratio", (SettingValueParser)SettingValueParsers.DOUBLE, (Object)1.0).build();
    @Internal
    @Description(value="Sets the minimum size for the lowest level segments. Any segments below this size are candidates for full-flush merges and be merged more aggressively in order to avoid having a long tail of small segments. Large values of this parameter increase the merging cost during indexing if you flush small segments")
    public static final Setting<Double> lucene_min_merge = SettingImpl.newBuilder((String)"internal.dbms.index.lucene.min_merge", (SettingValueParser)SettingValueParsers.DOUBLE, (Object)0.1).build();
    @Internal
    @Description(value="Determines the largest segment (measured by total byte size of the segment's files, in MB) that may be merged with other segments. Small values (e. g., less than 50 MB) are best for interactive indexing, as this limits the length of pauses while indexing to a few seconds. Larger values are best for batched indexing and speedier searches.")
    public static final Setting<Double> lucene_max_merge = SettingImpl.newBuilder((String)"internal.dbms.index.lucene.max_merge", (SettingValueParser)SettingValueParsers.DOUBLE, (Object)2048.0).build();
    @Internal
    @Description(value="Determines the amount of RAM that may be used for buffering added documents and deletions before they are flushed to the Directory. Generally for faster indexing performance it's best to flush by RAM usage instead of document count and use as large a RAM buffer as you can.")
    public static final Setting<Double> lucene_standard_ram_buffer_size = SettingImpl.newBuilder((String)"internal.dbms.index.lucene.standard_ram_buffer_size", (SettingValueParser)SettingValueParsers.DOUBLE, (Object)16.0).build();
    @Internal
    @Description(value="Determines the amount of RAM that may be used for buffering added documents and deletions before they are flushed to the Directory. Generally for faster indexing performance it's best to flush by RAM usage instead of document count and use as large a RAM buffer as you can. This is only used during the creation of the index.")
    public static final Setting<Double> lucene_population_ram_buffer_size = SettingImpl.newBuilder((String)"internal.dbms.index.lucene.population_ram_buffer_size", (SettingValueParser)SettingValueParsers.DOUBLE, (Object)50.0).build();
    @Internal
    @Description(value="Determines the amount of RAM that may be used for buffering added documents and deletions before they are flushed to the Directory. Generally for faster indexing performance it's best to flush by RAM usage instead of document count and use as large a RAM buffer as you can. This is only used for vector indexes during the creation of the index.")
    public static final Setting<Double> vector_population_ram_buffer_size = SettingImpl.newBuilder((String)"internal.dbms.index.vector.population_ram_buffer_size", (SettingValueParser)SettingValueParsers.DOUBLE, (Object)1.0).build();
    @Internal
    @Description(value="Sets the merge scheduler used by this writer. The default is ConcurrentMergeScheduler. If 'false' separate threads will be used for merge, if 'true' the merges will be done sequentially by the current thread.")
    public static final Setting<Boolean> lucene_population_serial_merge_scheduler = SettingImpl.newBuilder((String)"internal.dbms.index.lucene.population_serial_merge_scheduler", (SettingValueParser)SettingValueParsers.BOOL, (Object)Boolean.TRUE).build();
    @Internal
    @Description(value="Controls whether any newly created indexes backed by lucene are populated during a sharded import. If 'true', the index will be created but NOT populated during import. Population would then occur during the shards initial recovery when the sharded database is created.")
    public static final Setting<Boolean> lucene_skip_population_during_sharded_import = SettingImpl.newBuilder((String)"internal.dbms.index.lucene.skip_population_during_sharded_import", (SettingValueParser)SettingValueParsers.BOOL, (Object)Boolean.TRUE).build();
}

