/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.neo4j.configuration.Config;
import org.neo4j.function.ThrowingBiConsumer;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.IndexFileSnapshotter;
import org.neo4j.kernel.api.impl.index.LuceneAllDocumentsReader;
import org.neo4j.kernel.api.impl.index.LucenePartitionAllDocumentsReader;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.WritableDatabaseIndex;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.partition.IndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;
import org.neo4j.kernel.api.impl.schema.writer.PartitionedIndexWriter;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.impl.index.schema.IndexUsageTracking;
import org.neo4j.logging.LogProvider;

public abstract class AbstractLuceneIndex<READER extends IndexReader>
implements IndexFileSnapshotter {
    private static final String KEY_STATUS = "status";
    private static final String ONLINE = "online";
    private static final Set<Map.Entry<String, String>> ONLINE_COMMIT_USER_DATA = Set.of(Map.entry("status", "online"));
    protected final PartitionedIndexStorage indexStorage;
    protected final IndexDescriptor descriptor;
    private final IndexPartitionFactory partitionFactory;
    private final Config config;
    protected final LogProvider logProvider;
    private final CopyOnWriteArrayList<AbstractIndexPartition> partitions = new CopyOnWriteArrayList();
    private volatile boolean open;

    public AbstractLuceneIndex(PartitionedIndexStorage indexStorage, IndexPartitionFactory partitionFactory, IndexDescriptor descriptor, Config config, LogProvider logProvider) {
        this.indexStorage = indexStorage;
        this.partitionFactory = partitionFactory;
        this.descriptor = descriptor;
        this.config = config;
        this.logProvider = logProvider;
    }

    public void create() throws IOException {
        this.ensureNotOpen();
        this.indexStorage.prepareFolder(this.indexStorage.getIndexFolder());
        this.indexStorage.reserveIndexFailureStorage();
        this.createNewPartitionFolder();
    }

    public void open() throws IOException {
        Set<Map.Entry<Path, Directory>> indexDirectories = this.indexStorage.openIndexDirectories().entrySet();
        ArrayList<AbstractIndexPartition> list = new ArrayList<AbstractIndexPartition>(indexDirectories.size());
        for (Map.Entry<Path, Directory> entry : indexDirectories) {
            list.add(this.partitionFactory.createPartition(entry.getKey(), entry.getValue()));
        }
        this.partitions.addAll(list);
        this.open = true;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean exists() throws IOException {
        List<Path> folders = this.indexStorage.listFolders();
        if (folders.isEmpty()) {
            return false;
        }
        for (Path folder : folders) {
            if (this.luceneDirectoryExists(folder)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        if (this.open) {
            return true;
        }
        Collection<Directory> directories = null;
        try {
            directories = this.indexStorage.openIndexDirectories().values();
            for (Directory directory : directories) {
                if (!ArrayUtils.isNotEmpty((Object[])directory.listAll())) continue;
                try (CheckIndex checker = new CheckIndex(directory);){
                    CheckIndex.Status status = checker.checkIndex();
                    if (status.clean) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (directories != null) {
                IOUtils.closeAllSilently(directories);
            }
        }
        return true;
    }

    public LuceneIndexWriter getIndexWriter(WritableDatabaseIndex<?, ?> writableDatabaseIndex) {
        this.ensureOpen();
        return new PartitionedIndexWriter(writableDatabaseIndex, this.config);
    }

    public READER getIndexReader(IndexUsageTracking usageTracker) throws IOException {
        this.ensureOpen();
        List<AbstractIndexPartition> partitions = this.getPartitions();
        return AbstractLuceneIndex.hasSinglePartition(partitions) ? this.createSimpleReader(partitions, usageTracker) : this.createPartitionedReader(partitions, usageTracker);
    }

    public IndexDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void drop() {
        try {
            this.close();
            this.indexStorage.cleanupFolder(this.indexStorage.getIndexFolder());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void flush(boolean merge) throws IOException {
        List<AbstractIndexPartition> partitions = this.getPartitions();
        for (AbstractIndexPartition partition : partitions) {
            IndexWriter writer = partition.getIndexWriter();
            writer.commit();
            if (!merge) continue;
            writer.forceMerge(1);
        }
    }

    public void close() throws IOException {
        this.open = false;
        IOUtils.closeAll(this.partitions);
        this.partitions.clear();
    }

    public LuceneAllDocumentsReader allDocumentsReader() {
        this.ensureOpen();
        ArrayList<SearcherReference> searchers = new ArrayList<SearcherReference>(this.partitions.size());
        try {
            for (AbstractIndexPartition partition : this.partitions) {
                searchers.add(partition.acquireSearcher());
            }
            List<LucenePartitionAllDocumentsReader> partitionReaders = searchers.stream().map(LucenePartitionAllDocumentsReader::new).toList();
            return new LuceneAllDocumentsReader(partitionReaders);
        }
        catch (IOException e) {
            IOUtils.closeAllSilently(searchers);
            throw new UncheckedIOException(e);
        }
    }

    public ResourceIterator<Path> snapshotFiles() throws IOException {
        if (this.indexStorage.getStoredIndexFailure() != null) {
            return Iterators.asResourceIterator((Iterator)Iterators.iterator((Object)this.indexStorage.getIndexFailureFile()));
        }
        this.ensureOpen();
        ArrayList<ResourceIterator<Path>> snapshotIterators = null;
        try {
            List<AbstractIndexPartition> partitions = this.getPartitions();
            snapshotIterators = new ArrayList<ResourceIterator<Path>>(partitions.size());
            for (AbstractIndexPartition partition : partitions) {
                snapshotIterators.add(partition.snapshot());
            }
            return Iterators.concatResourceIterators(snapshotIterators.iterator());
        }
        catch (Exception e) {
            if (snapshotIterators != null) {
                try {
                    IOUtils.closeAll(snapshotIterators);
                }
                catch (IOException ex) {
                    e.addSuppressed(ex);
                }
            }
            throw e;
        }
    }

    public void maybeRefreshBlocking() throws IOException {
        try {
            this.getPartitions().parallelStream().forEach(AbstractLuceneIndex::maybeRefreshPartition);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private static void maybeRefreshPartition(AbstractIndexPartition partition) {
        try {
            partition.maybeRefreshBlocking();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<AbstractIndexPartition> getPartitions() {
        this.ensureOpen();
        return this.partitions;
    }

    public static boolean hasSinglePartition(List<AbstractIndexPartition> partitions) {
        return partitions.size() == 1;
    }

    public static AbstractIndexPartition getFirstPartition(List<AbstractIndexPartition> partitions) {
        return partitions.get(0);
    }

    AbstractIndexPartition addNewPartition() throws IOException {
        this.ensureOpen();
        Path partitionFolder = this.createNewPartitionFolder();
        Directory directory = this.indexStorage.openDirectory(partitionFolder);
        AbstractIndexPartition indexPartition = this.partitionFactory.createPartition(partitionFolder, directory);
        this.partitions.add(indexPartition);
        return indexPartition;
    }

    protected void ensureOpen() {
        if (!this.open) {
            throw new IllegalStateException("Please open lucene index before working with it.");
        }
    }

    protected void ensureNotOpen() {
        if (this.open) {
            throw new IllegalStateException("Lucene index should not be open to be able to perform required operation.");
        }
    }

    protected static List<SearcherReference> acquireSearchers(List<AbstractIndexPartition> partitions) throws IOException {
        ArrayList<SearcherReference> searchers = new ArrayList<SearcherReference>(partitions.size());
        try {
            for (AbstractIndexPartition partition : partitions) {
                searchers.add(partition.acquireSearcher());
            }
            return searchers;
        }
        catch (IOException e) {
            IOUtils.closeAllSilently(searchers);
            throw e;
        }
    }

    private boolean luceneDirectoryExists(Path folder) throws IOException {
        try (Directory directory = this.indexStorage.openDirectory(folder);){
            boolean bl = DirectoryReader.indexExists((Directory)directory);
            return bl;
        }
    }

    private Path createNewPartitionFolder() throws IOException {
        Path partitionFolder = this.indexStorage.getPartitionFolder(this.partitions.size() + 1);
        this.indexStorage.prepareFolder(partitionFolder);
        return partitionFolder;
    }

    public boolean isOnline() throws IOException {
        this.ensureOpen();
        AbstractIndexPartition partition = AbstractLuceneIndex.getFirstPartition(this.getPartitions());
        Directory directory = partition.getDirectory();
        try (DirectoryReader reader = DirectoryReader.open((Directory)directory);){
            Map userData = reader.getIndexCommit().getUserData();
            boolean bl = ONLINE.equals(userData.get(KEY_STATUS));
            return bl;
        }
    }

    public void markAsOnline() throws IOException {
        this.ensureOpen();
        AbstractIndexPartition partition = AbstractLuceneIndex.getFirstPartition(this.getPartitions());
        IndexWriter indexWriter = partition.getIndexWriter();
        indexWriter.setLiveCommitData(ONLINE_COMMIT_USER_DATA);
        this.flush(false);
    }

    public void markAsFailed(String failure) throws IOException {
        this.indexStorage.storeIndexFailure(failure);
    }

    protected abstract READER createSimpleReader(List<AbstractIndexPartition> var1, IndexUsageTracking var2) throws IOException;

    protected abstract READER createPartitionedReader(List<AbstractIndexPartition> var1, IndexUsageTracking var2) throws IOException;

    protected void accessClosedDirectories(ThrowingBiConsumer<Integer, Directory, IOException> visitor) throws IOException {
        for (AbstractIndexPartition partition : this.getPartitions()) {
            partition.accessClosedDirectory(visitor);
        }
    }

    long sizeInBytes() {
        return this.indexStorage.sizeInBytes();
    }
}

