/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.impl.index.LuceneIndexWriter;

class ReservingLuceneIndexWriter
extends LuceneIndexWriter {
    private final AtomicLong reservedDocs = new AtomicLong();

    ReservingLuceneIndexWriter(Directory directory, IndexWriterConfig config) throws IOException {
        super(directory, config);
    }

    synchronized void reserveInsertions(int insertionsCount) throws IOException, IndexCapacityExceededException {
        if (insertionsCount <= 0) {
            return;
        }
        if (this.totalNumberOfDocumentsExceededLuceneCapacity(insertionsCount)) {
            this.writer.forceMergeDeletes();
            if (this.totalNumberOfDocumentsExceededLuceneCapacity(insertionsCount)) {
                this.writer.forceMerge(1);
                if (this.totalNumberOfDocumentsExceededLuceneCapacity(insertionsCount)) {
                    throw new IndexCapacityExceededException((long)insertionsCount, (long)this.writer.maxDoc(), this.maxDocLimit());
                }
            }
        }
        this.reservedDocs.addAndGet(insertionsCount);
    }

    void removeReservedInsertions(int insertionsCount) {
        if (insertionsCount > 0) {
            this.reservedDocs.addAndGet(-insertionsCount);
        }
    }

    private boolean totalNumberOfDocumentsExceededLuceneCapacity(int newAdditions) {
        return this.reservedDocs.get() + (long)this.writer.maxDoc() + (long)newAdditions >= this.maxDocLimit();
    }
}

