/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.index.impl.lucene.Hits;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.impl.index.HitsPrimitiveLongIterator;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.impl.api.index.sampling.NonUniqueIndexSampler;
import org.neo4j.register.Register;

class LuceneIndexAccessorReader
implements IndexReader {
    private final IndexSearcher searcher;
    private final LuceneDocumentStructure documentLogic;
    private final Closeable onClose;
    private final CancellationRequest cancellation;
    private final int bufferSizeLimit;

    LuceneIndexAccessorReader(IndexSearcher searcher, LuceneDocumentStructure documentLogic, Closeable onClose, CancellationRequest cancellation, int bufferSizeLimit) {
        this.searcher = searcher;
        this.documentLogic = documentLogic;
        this.onClose = onClose;
        this.cancellation = cancellation;
        this.bufferSizeLimit = bufferSizeLimit;
    }

    public long sampleIndex(Register.DoubleLong.Out result) throws IndexNotFoundKernelException {
        NonUniqueIndexSampler sampler = new NonUniqueIndexSampler(this.bufferSizeLimit);
        org.apache.lucene.index.IndexReader indexReader = this.luceneIndexReader();
        try (TermEnum terms = indexReader.terms();){
            while (terms.next()) {
                Term term = terms.term();
                if (!"id".equals(term.field())) {
                    String value = term.text();
                    int frequency = terms.docFreq();
                    sampler.include(value, (long)frequency);
                }
                this.checkCancellation();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        sampler.result(result);
        return indexReader.numDocs();
    }

    public PrimitiveLongIterator seek(Object value) {
        return this.query((Query)this.documentLogic.newSeekQuery(value));
    }

    public PrimitiveLongIterator rangeSeekByNumberInclusive(Number lower, Number upper) {
        return this.query((Query)this.documentLogic.newInclusiveNumericRangeSeekQuery(lower, upper));
    }

    public PrimitiveLongIterator rangeSeekByString(String lower, boolean includeLower, String upper, boolean includeUpper) {
        return this.query((Query)this.documentLogic.newRangeSeekByStringQuery(lower, includeLower, upper, includeUpper));
    }

    public PrimitiveLongIterator rangeSeekByPrefix(String prefix) {
        return this.query((Query)this.documentLogic.newRangeSeekByPrefixQuery(prefix));
    }

    public PrimitiveLongIterator scan() {
        return this.query((Query)this.documentLogic.newScanQuery());
    }

    public int countIndexedNodes(long nodeId, Object propertyValue) {
        TermQuery nodeIdQuery = new TermQuery(this.documentLogic.newTermForChangeOrRemove(nodeId));
        TermQuery valueQuery = this.documentLogic.newSeekQuery(propertyValue);
        BooleanQuery nodeIdAndValueQuery = new BooleanQuery(true);
        nodeIdAndValueQuery.add((Query)nodeIdQuery, BooleanClause.Occur.MUST);
        nodeIdAndValueQuery.add((Query)valueQuery, BooleanClause.Occur.MUST);
        try {
            Hits hits = new Hits(this.searcher, (Query)nodeIdAndValueQuery, null);
            return hits.length();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<Class> valueTypesInIndex() {
        HashSet<Class> types = new HashSet<Class>();
        try (TermEnum terms = this.luceneIndexReader().terms();){
            while (terms.next()) {
                String field = terms.term().field();
                if ("id".equals(field)) continue;
                switch (LuceneDocumentStructure.ValueEncoding.fromKey(field)) {
                    case Number: {
                        types.add(Number.class);
                        break;
                    }
                    case String: {
                        types.add(String.class);
                        break;
                    }
                    case Array: {
                        types.add(Array.class);
                        break;
                    }
                    case Bool: {
                        types.add(Boolean.class);
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return types;
    }

    public void close() {
        try {
            this.onClose.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void checkCancellation() throws IndexNotFoundKernelException {
        if (this.cancellation.cancellationRequested()) {
            throw new IndexNotFoundKernelException("Index dropped while sampling.");
        }
    }

    protected org.apache.lucene.index.IndexReader luceneIndexReader() {
        return this.searcher.getIndexReader();
    }

    protected PrimitiveLongIterator query(Query query) {
        try {
            Hits hits = new Hits(this.searcher, query, null);
            return new HitsPrimitiveLongIterator(hits, this.documentLogic);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

