/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.LuceneKernelExtensions;
import org.neo4j.kernel.api.impl.index.LuceneSchemaIndexProvider;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.spi.KernelContext;

public class LuceneSchemaIndexProviderFactory
extends KernelExtensionFactory<Dependencies> {
    public static final String KEY = "lucene";
    public static final SchemaIndexProvider.Descriptor PROVIDER_DESCRIPTOR = new SchemaIndexProvider.Descriptor("lucene", "1.0");

    public LuceneSchemaIndexProviderFactory() {
        super(KEY);
    }

    public LuceneSchemaIndexProvider newInstance(KernelContext context, Dependencies dependencies) throws Throwable {
        boolean ephemeral = (Boolean)dependencies.getConfig().get(GraphDatabaseFacadeFactory.Configuration.ephemeral);
        FileSystemAbstraction fileSystem = context.fileSystem();
        DirectoryFactory directoryFactory = LuceneKernelExtensions.directoryFactory(ephemeral, fileSystem);
        return new LuceneSchemaIndexProvider(fileSystem, directoryFactory, context.storeDir());
    }

    public static interface Dependencies {
        public Config getConfig();
    }
}

