/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.neo4j.index.impl.lucene.EntityId;
import org.neo4j.index.impl.lucene.FullTxData;
import org.neo4j.index.impl.lucene.LuceneIndex;
import org.neo4j.index.impl.lucene.LuceneTransactionState;
import org.neo4j.index.impl.lucene.TxData;
import org.neo4j.index.impl.lucene.TxDataHolder;
import org.neo4j.index.lucene.QueryContext;
import org.neo4j.index.lucene.ValueContext;

public class ExactTxData
extends TxData {
    private Map<String, Map<Object, Set<EntityId>>> data;
    private boolean hasOrphans;

    ExactTxData(LuceneIndex index) {
        super(index);
    }

    @Override
    void add(TxDataHolder holder, EntityId entityId, String key, Object value) {
        this.idCollection(key, value, true).add(entityId);
    }

    private Set<EntityId> idCollection(String key, Object value, boolean create) {
        Map<Object, Set<EntityId>> keyMap = this.keyMap(key, create);
        if (keyMap == null) {
            return null;
        }
        Set<EntityId> ids = keyMap.get(value);
        if (ids == null && create) {
            ids = new HashSet<EntityId>();
            keyMap.put(value, ids);
            if (value == null) {
                this.hasOrphans = true;
            }
        }
        return ids;
    }

    private Map<Object, Set<EntityId>> keyMap(String key, boolean create) {
        Map<Object, Set<EntityId>> inner;
        if (this.data == null) {
            if (create) {
                this.data = new HashMap<String, Map<Object, Set<EntityId>>>();
            } else {
                return null;
            }
        }
        if ((inner = this.data.get(key)) == null && create) {
            inner = new HashMap<Object, Set<EntityId>>();
            this.data.put(key, inner);
            if (key == null) {
                this.hasOrphans = true;
            }
        }
        return inner;
    }

    private TxData toFullTxData() {
        FullTxData data = new FullTxData(this.index);
        if (this.data != null) {
            for (Map.Entry<String, Map<Object, Set<EntityId>>> entry : this.data.entrySet()) {
                String key = entry.getKey();
                for (Map.Entry<Object, Set<EntityId>> valueEntry : entry.getValue().entrySet()) {
                    Object value = valueEntry.getKey();
                    for (EntityId id : valueEntry.getValue()) {
                        data.add(null, id, key, value);
                    }
                }
            }
        }
        return data;
    }

    @Override
    void close() {
    }

    @Override
    Collection<EntityId> query(TxDataHolder holder, Query query, QueryContext contextOrNull) {
        if (contextOrNull != null && contextOrNull.getTradeCorrectnessForSpeed()) {
            return Collections.emptyList();
        }
        TxData fullTxData = this.toFullTxData();
        holder.set(fullTxData);
        return fullTxData.query(holder, query, contextOrNull);
    }

    @Override
    void remove(TxDataHolder holder, EntityId entityId, String key, Object value) {
        if (this.data == null) {
            return;
        }
        if (key == null || value == null) {
            TxData fullData = this.toFullTxData();
            fullData.remove(holder, entityId, key, value);
            holder.set(fullData);
        } else {
            Set<EntityId> ids = this.idCollection(key, value, false);
            if (ids != null) {
                ids.remove(entityId);
            }
        }
    }

    @Override
    Collection<EntityId> get(TxDataHolder holder, String key, Object value) {
        Set<EntityId> ids = this.idCollection(key, value = value instanceof ValueContext ? ((ValueContext)value).getCorrectValue() : value.toString(), false);
        if (ids == null || ids.isEmpty()) {
            return Collections.emptySet();
        }
        return ids;
    }

    @Override
    Collection<EntityId> getOrphans(String key) {
        if (!this.hasOrphans) {
            return null;
        }
        Set<EntityId> orphans = this.idCollection(null, null, false);
        Set<EntityId> keyOrphans = this.idCollection(key, null, false);
        return LuceneTransactionState.merge(orphans, keyOrphans);
    }

    @Override
    IndexSearcher asSearcher(TxDataHolder holder, QueryContext context) {
        if (context != null && context.getTradeCorrectnessForSpeed()) {
            return null;
        }
        TxData fullTxData = this.toFullTxData();
        holder.set(fullTxData);
        return fullTxData.asSearcher(holder, context);
    }
}

