/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.store.Directory;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.helpers.TaskControl;
import org.neo4j.helpers.TaskCoordinator;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.api.direct.BoundedIterable;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.DirectorySupport;
import org.neo4j.kernel.api.impl.index.IndexWriterFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterStatus;
import org.neo4j.kernel.api.impl.index.LuceneAllDocumentsReader;
import org.neo4j.kernel.api.impl.index.LuceneAllEntriesIndexAccessorReader;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.index.LuceneIndexAccessorReader;
import org.neo4j.kernel.api.impl.index.LuceneSnapshotter;
import org.neo4j.kernel.api.impl.index.ReservingLuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.Reservation;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.UpdateMode;

abstract class LuceneIndexAccessor
implements IndexAccessor {
    protected final LuceneDocumentStructure documentStructure;
    protected final LuceneReferenceManager<IndexSearcher> searcherManager;
    protected final ReservingLuceneIndexWriter writer;
    private final IndexWriterStatus writerStatus;
    private final Directory dir;
    private final File dirFile;
    private final int bufferSizeLimit;
    private final TaskCoordinator taskCoordinator = new TaskCoordinator(10L, TimeUnit.MILLISECONDS);
    private final PrimitiveLongVisitor<IOException> removeFromLucene = new PrimitiveLongVisitor<IOException>(){

        public boolean visited(long nodeId) throws IOException {
            LuceneIndexAccessor.this.remove(nodeId);
            return false;
        }
    };

    LuceneIndexAccessor(LuceneDocumentStructure documentStructure, IndexWriterFactory<ReservingLuceneIndexWriter> indexWriterFactory, IndexWriterStatus writerStatus, DirectoryFactory dirFactory, File dirFile, int bufferSizeLimit) throws IOException {
        this.documentStructure = documentStructure;
        this.dirFile = dirFile;
        this.bufferSizeLimit = bufferSizeLimit;
        this.dir = dirFactory.open(dirFile);
        this.writer = indexWriterFactory.create(this.dir);
        this.writerStatus = writerStatus;
        this.searcherManager = new LuceneReferenceManager.Wrap<IndexSearcher>((ReferenceManager<IndexSearcher>)this.writer.createSearcherManager());
    }

    LuceneIndexAccessor(LuceneDocumentStructure documentStructure, ReservingLuceneIndexWriter writer, LuceneReferenceManager<IndexSearcher> searcherManager, IndexWriterStatus writerStatus, Directory dir, File dirFile, int bufferSizeLimit) {
        this.documentStructure = documentStructure;
        this.writer = writer;
        this.searcherManager = searcherManager;
        this.writerStatus = writerStatus;
        this.dir = dir;
        this.dirFile = dirFile;
        this.bufferSizeLimit = bufferSizeLimit;
    }

    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        switch (mode) {
            case ONLINE: {
                return new LuceneIndexUpdater(false);
            }
            case BATCHED: {
                return new LuceneIndexUpdater(true);
            }
        }
        throw new ThisShouldNotHappenError("Stefan", "Unsupported update mode");
    }

    public void drop() throws IOException {
        this.taskCoordinator.cancel();
        this.closeIndexResources();
        try {
            this.taskCoordinator.awaitCompletion();
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while waiting for concurrent tasks to complete.", e);
        }
        DirectorySupport.deleteDirectoryContents(this.dir);
    }

    public void force() throws IOException {
        this.writerStatus.commitAsOnline(this.writer);
        this.refreshSearcherManager();
    }

    public void flush() throws IOException {
        this.refreshSearcherManager();
    }

    public void close() throws IOException {
        this.closeIndexResources();
        this.dir.close();
    }

    private void closeIndexResources() throws IOException {
        this.writerStatus.close(this.writer);
        this.searcherManager.close();
    }

    public IndexReader newReader() {
        final IndexSearcher searcher = this.searcherManager.acquire();
        final TaskControl token = this.taskCoordinator.newInstance();
        Closeable closeable = new Closeable(){

            @Override
            public void close() throws IOException {
                LuceneIndexAccessor.this.searcherManager.release(searcher);
                token.close();
            }
        };
        return this.makeNewReader(searcher, closeable, (CancellationRequest)token);
    }

    protected IndexReader makeNewReader(IndexSearcher searcher, Closeable closeable, CancellationRequest cancellation) {
        return new LuceneIndexAccessorReader(searcher, this.documentStructure, closeable, cancellation, this.bufferSizeLimit);
    }

    public BoundedIterable<Long> newAllEntriesReader() {
        return new LuceneAllEntriesIndexAccessorReader(new LuceneAllDocumentsReader(this.searcherManager), this.documentStructure);
    }

    public ResourceIterator<File> snapshotFiles() throws IOException {
        return new LuceneSnapshotter().snapshot(this.dirFile, this.writer);
    }

    private void addRecovered(long nodeId, Object value) throws IOException, IndexCapacityExceededException {
        Fieldable encodedValue = this.documentStructure.encodeAsFieldable(value);
        this.writer.updateDocument(this.documentStructure.newQueryForChangeOrRemove(nodeId), this.documentStructure.newDocumentRepresentingProperty(nodeId, encodedValue));
    }

    protected void add(long nodeId, Object value) throws IOException, IndexCapacityExceededException {
        Fieldable encodedValue = this.documentStructure.encodeAsFieldable(value);
        this.writer.addDocument(this.documentStructure.newDocumentRepresentingProperty(nodeId, encodedValue));
    }

    protected void change(long nodeId, Object value) throws IOException, IndexCapacityExceededException {
        Fieldable encodedValue = this.documentStructure.encodeAsFieldable(value);
        this.writer.updateDocument(this.documentStructure.newQueryForChangeOrRemove(nodeId), this.documentStructure.newDocumentRepresentingProperty(nodeId, encodedValue));
    }

    protected void remove(long nodeId) throws IOException {
        this.writer.deleteDocuments(this.documentStructure.newQueryForChangeOrRemove(nodeId));
    }

    private synchronized void refreshSearcherManager() throws IOException {
        this.searcherManager.maybeRefresh();
    }

    private class LuceneIndexUpdater
    implements IndexUpdater {
        private final boolean isBatched;

        private LuceneIndexUpdater(boolean inBatched) {
            this.isBatched = inBatched;
        }

        public Reservation validate(Iterable<NodePropertyUpdate> updates) throws IOException, IndexCapacityExceededException {
            int insertionsCount = 0;
            for (NodePropertyUpdate update : updates) {
                if (update.getUpdateMode() != UpdateMode.ADDED && update.getUpdateMode() != UpdateMode.CHANGED) continue;
                ++insertionsCount;
            }
            LuceneIndexAccessor.this.writer.reserveInsertions(insertionsCount);
            final int insertions = insertionsCount;
            return new Reservation(){
                boolean released;

                public void release() {
                    if (this.released) {
                        throw new IllegalStateException("Reservation was already released. Previously reserved " + insertions + " insertions");
                    }
                    LuceneIndexAccessor.this.writer.removeReservedInsertions(insertions);
                    this.released = true;
                }
            };
        }

        public void process(NodePropertyUpdate update) throws IOException, IndexCapacityExceededException {
            switch (update.getUpdateMode()) {
                case ADDED: {
                    if (this.isBatched) {
                        LuceneIndexAccessor.this.addRecovered(update.getNodeId(), update.getValueAfter());
                        break;
                    }
                    LuceneIndexAccessor.this.add(update.getNodeId(), update.getValueAfter());
                    break;
                }
                case CHANGED: {
                    LuceneIndexAccessor.this.change(update.getNodeId(), update.getValueAfter());
                    break;
                }
                case REMOVED: {
                    LuceneIndexAccessor.this.remove(update.getNodeId());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        public void close() throws IOException, IndexEntryConflictException {
            if (!this.isBatched) {
                LuceneIndexAccessor.this.refreshSearcherManager();
            }
        }

        public void remove(PrimitiveLongSet nodeIds) throws IOException {
            nodeIds.visitKeys(LuceneIndexAccessor.this.removeFromLucene);
        }
    }

    public static interface LuceneReferenceManager<G>
    extends Closeable {
        public G acquire();

        public boolean maybeRefresh() throws IOException;

        public void release(G var1) throws IOException;

        public static class Wrap<G>
        implements LuceneReferenceManager<G> {
            private final ReferenceManager<G> delegate;

            Wrap(ReferenceManager<G> delegate) {
                this.delegate = delegate;
            }

            @Override
            public G acquire() {
                return (G)this.delegate.acquire();
            }

            @Override
            public boolean maybeRefresh() throws IOException {
                return this.delegate.maybeRefresh();
            }

            @Override
            public void release(G reference) throws IOException {
                this.delegate.release(reference);
            }

            @Override
            public void close() throws IOException {
                this.delegate.close();
            }
        }
    }
}

